(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    864214,      18636]
NotebookOptionsPosition[    850694,      18315]
NotebookOutlinePosition[    851068,      18331]
CellTagsIndexPosition[    851025,      18328]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Kontrola", " ", "za", " ", "k", " ", "po", " ", "Sekulovicu"}], 
    ",", " ", 
    RowBox[{"269", " ", "strana"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Ploca", " ", "je", " ", "axb", " ", "i", " ", "koordinatni", " ", 
     "pocetak", " ", "je", " ", "u", " ", "0"}], ",", "0"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Interpolacione", " ", "funkcije"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "=", " ", 
   RowBox[{"\[Alpha]1", "+", 
    RowBox[{"\[Alpha]2", "*", "x"}], "+", 
    RowBox[{"\[Alpha]3", "*", "y"}], "+", 
    RowBox[{"\[Alpha]4", "*", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"\[Alpha]5", "*", "x", "*", "y"}], "+", 
    RowBox[{"\[Alpha]6", "*", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"\[Alpha]7", "*", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"\[Alpha]8", "*", 
     SuperscriptBox["x", "2"], "*", "y"}], "+", 
    RowBox[{"\[Alpha]9", "*", "x", "*", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"\[Alpha]10", "*", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"\[Alpha]11", "*", 
     SuperscriptBox["x", "3"], "*", "y"}], "+", 
    RowBox[{"\[Alpha]12", "*", "x", "*", 
     SuperscriptBox["y", "3"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", "y", ",", 
      SuperscriptBox["x", "2"], ",", 
      RowBox[{"x", "*", "y"}], ",", 
      SuperscriptBox["y", "2"], ",", 
      SuperscriptBox["x", "3"], ",", 
      RowBox[{
       SuperscriptBox["x", "2"], "*", "y"}], ",", 
      RowBox[{"x", "*", 
       SuperscriptBox["y", "2"]}], ",", 
      SuperscriptBox["y", "3"], ",", 
      RowBox[{
       SuperscriptBox["x", "3"], "*", "y"}], ",", 
      RowBox[{"x", "*", 
       SuperscriptBox["y", "3"]}]}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<A = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", "A", "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dwPodx", "=", 
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"w", ",", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dwPody", "=", 
    RowBox[{"D", "[", 
     RowBox[{"w", ",", "y"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dgZaX", "=", 
   RowBox[{"-", "a"}]}], ";", 
  RowBox[{"ggZaX", "=", "a"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dgZaY", "=", 
    RowBox[{"-", "b"}]}], ";", 
   RowBox[{"ggZaY", "=", "b"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"w1", " ", "=", " ", 
    RowBox[{"w", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "dgZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "dgZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]1x", " ", "=", 
    RowBox[{"dwPody", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "dgZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "dgZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]1y", " ", "=", " ", 
    RowBox[{"dwPodx", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "dgZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "dgZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"w2", " ", "=", " ", 
    RowBox[{"w", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "ggZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "dgZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]2x", " ", "=", " ", 
    RowBox[{"dwPody", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "ggZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "dgZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]2y", " ", "=", " ", 
    RowBox[{"dwPodx", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "ggZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "dgZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"w3", " ", "=", " ", 
    RowBox[{"w", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "ggZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "ggZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]3x", " ", "=", 
    RowBox[{"dwPody", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "ggZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "ggZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]3y", " ", "=", " ", 
   RowBox[{"dwPodx", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "ggZaX"}], ",", 
      RowBox[{"y", "\[Rule]", "ggZaY"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"w4", " ", "=", " ", 
    RowBox[{"w", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "dgZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "ggZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]4x", " ", "=", 
    RowBox[{"dwPody", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "dgZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "ggZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]4y", " ", "=", " ", 
    RowBox[{"dwPodx", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "dgZaX"}], ",", 
       RowBox[{"y", "\[Rule]", "ggZaY"}]}], "}"}]}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Cmat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w1", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "          ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1x", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", "  ", "  ", "  ", "  ", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]1y", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w2", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", "  ", "  ", "  ", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2x", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", "  ", "  ", "  ", "  ", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]2y", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w3", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", "  ", "  ", "  ", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3x", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "           ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]3y", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"w4", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "          ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4x", ",", "\[Alpha]12"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", "  ", "  ", "  ", "  ", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]1"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]2"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]3"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]4"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]5"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]6"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]7"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]8"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]9"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]10"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]11"}], "]"}], ",", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"\[Theta]4y", ",", "\[Alpha]12"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<C = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", "Cmat", "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CmatInverzna", "=", 
   RowBox[{"Inverse", "[", "Cmat", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<\!\(\*SuperscriptBox[\(C\), \(-1\)]\) =\!\(\*FractionBox[\(\(1\)\(\\\
\ \)\), \(8  ab\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"8", "*", "a", "*", "b", "*", "CmatInverzna"}], "]"}], "]"}]}],
     "]"}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", 
   RowBox[{"A", ".", "CmatInverzna"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<N = \!\(\*FractionBox[\(1\), \(8\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"8", "*", "Ni"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "B"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Cvor", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN11podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN12podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN13podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN11pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN12pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN13pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN11podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
   RowBox[{"dN12podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
   RowBox[{"dN13podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Cvor", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN21podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN22podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "5"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN23podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "6"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN21pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN22pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "5"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN23pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "6"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN21podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
   RowBox[{"dN22podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "5"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
   RowBox[{"dN23podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "6"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Cvor", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN31podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "7"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN32podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "8"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN33podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "9"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN31pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "7"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN32pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "8"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN33pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "9"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN31podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "7"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
   RowBox[{"dN32podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "8"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
   RowBox[{"dN33podxdy", "=", 
    RowBox[{"2", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"Ni", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "9"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Cvor", " ", "4"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN41podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "10"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN42podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "11"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN43podx", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "12"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN41pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "10"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN42pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "11"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"dN43pody", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "12"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN41podxdy", "=", 
   RowBox[{"2", "*", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Ni", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "10"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"dN42podxdy", "=", 
   RowBox[{"2", "*", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Ni", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "11"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], ";", 
  RowBox[{"dN43podxdy", "=", 
   RowBox[{"2", "*", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Ni", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "12"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"-", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "dN11podx", ",", "dN12podx", ",", "dN13podx", ",", "dN21podx", ",", 
        "dN22podx", ",", "dN23podx", ",", "dN31podx", ",", "dN32podx", ",", 
        "dN33podx", ",", "dN41podx", ",", "dN42podx", ",", "dN43podx"}], 
       "}"}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"{", 
       RowBox[{
       "dN11pody", ",", "dN12pody", ",", "dN13pody", ",", "dN21pody", ",", 
        "dN22pody", ",", "dN23pody", ",", "dN31pody", ",", "dN32pody", ",", 
        "dN33pody", ",", "dN41pody", ",", "dN42pody", ",", "dN43pody"}], 
       "}"}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"{", 
       RowBox[{
       "dN11podxdy", ",", "dN12podxdy", ",", "dN13podxdy", ",", "dN21podxdy", 
        ",", "dN22podxdy", ",", "dN23podxdy", ",", "dN31podxdy", ",", 
        "dN32podxdy", ",", "dN33podxdy", ",", "dN41podxdy", ",", "dN42podxdy",
         ",", "dN43podxdy"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<B = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", "B", "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "elasticnosti"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DelOpsta", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Em", "*", 
      SuperscriptBox["h", "3"]}], 
     RowBox[{"12", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Nu]", "2"]}], ")"}]}]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "\[Nu]", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Nu]", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        FractionBox[
         RowBox[{"1", "-", "\[Nu]"}], "2"]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<D = \!\(\*FractionBox[\(Em*\*SuperscriptBox[\(h\), \(3\)]\), \
\(12*\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"12", "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Nu]", "2"]}], ")"}]}], 
         RowBox[{"Em", "*", 
          SuperscriptBox["h", "3"]}]], "*", "DelOpsta"}], "]"}], "]"}]}], 
    "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "krutosti"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RSekulovic", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "12"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<A = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "A", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AzaRIvrsta", "=", 
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<AzaRIvrsta = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "AzaRIvrsta", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AzaRIIvrsta", "=", 
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<AzaRIIvrsta = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "AzaRIIvrsta", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AzaRIIIvrsta", "=", 
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{"D", "[", 
     RowBox[{"A", ",", "x", ",", "y"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<AzaRIIIvrsta = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "AzaRIIIvrsta", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "n", "]"}], ";", 
  RowBox[{"n", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"n", "\[LessEqual]", "12"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"RSekulovic", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "n"}], "]"}], "]"}], "=", 
      RowBox[{"AzaRIvrsta", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "n"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RSekulovic", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "n"}], "]"}], "]"}], "=", 
      RowBox[{"AzaRIIvrsta", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "n"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"RSekulovic", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "n"}], "]"}], "]"}], "=", 
      RowBox[{"AzaRIIIvrsta", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "n"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<R = -\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "*", "RSekulovic"}], "]"}], "]"}]}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"IntegrandZaKSekulovic", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "RSekulovic", "]"}], ".", "DelOpsta", ".", 
    "RSekulovic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kSekulovic", "=", 
    RowBox[{
     RowBox[{"Transpose", "[", "CmatInverzna", "]"}], ".", 
     RowBox[{"Integrate", "[", 
      RowBox[{"IntegrandZaKSekulovic", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "dgZaX", ",", "ggZaX"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "dgZaY", ",", "ggZaY"}], "}"}]}], "]"}], ".", 
     "CmatInverzna"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"IntegrandZak", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "B", "]"}], ".", "DelOpsta", ".", "B"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "12"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"m", ",", "n"}], "]"}], ";", 
  RowBox[{"m", "=", "1"}], ";", 
  RowBox[{"n", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"m", "\[LessEqual]", "12"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Clear", "[", "n", "]"}], ";", 
     RowBox[{"n", "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"n", "\[LessEqual]", "12"}], ",", "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"k", "[", 
          RowBox[{"[", 
           RowBox[{"m", ",", "n"}], "]"}], "]"}], "=", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{"IntegrandZak", "[", 
            RowBox[{"[", 
             RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "dgZaX", ",", "ggZaX"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", "dgZaY", ",", "ggZaY"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<k_\>\"", ",", "\"\<\>\"", ",", "m", ",", "\"\<-\>\"", ",", "n", 
          ",", "\"\< = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  \
ab \((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[\>\"", ",", 
          RowBox[{"FullSimplify", "[", 
           RowBox[{
            FractionBox[
             RowBox[{"48", "*", "a", "*", "b", "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                SuperscriptBox["\[Nu]", "2"]}], ")"}]}], 
             RowBox[{"Em", "*", 
              SuperscriptBox["h", "3"]}]], "*", 
            RowBox[{"k", "[", 
             RowBox[{"[", 
              RowBox[{"m", ",", "n"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<]; kSekulovic_\>\"", ",", "\"\<\>\"", ",", "m", ",", 
          "\"\<-\>\"", ",", "n", ",", 
          "\"\< = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \
\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[\>\"", ",", 
          RowBox[{"FullSimplify", "[", 
           RowBox[{
            FractionBox[
             RowBox[{"48", "*", "a", "*", "b", "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                SuperscriptBox["\[Nu]", "2"]}], ")"}]}], 
             RowBox[{"Em", "*", 
              SuperscriptBox["h", "3"]}]], "*", 
            RowBox[{"kSekulovic", "[", 
             RowBox[{"[", 
              RowBox[{"m", ",", "n"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<]\>\""}], "]"}], ";", "\[IndentingNewLine]", "\t", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Kontrola: k - kSekulovic = \>\"", ",", 
          RowBox[{"MatrixForm", "[", 
           RowBox[{"FullSimplify", "[", 
            RowBox[{
             RowBox[{"k", "[", 
              RowBox[{"[", 
               RowBox[{"m", ",", "n"}], "]"}], "]"}], "-", 
             RowBox[{"kSekulovic", "[", 
              RowBox[{"[", 
               RowBox[{"m", ",", "n"}], "]"}], "]"}]}], "]"}], "]"}]}], "]"}],
         ";", "\[IndentingNewLine]", "\t", 
        RowBox[{"n", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"m", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<kSekulovic = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  \
ab \((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"48", "*", "a", "*", "b", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Nu]", "2"]}], ")"}]}], 
        RowBox[{"Em", "*", 
         SuperscriptBox["h", "3"]}]], "*", "kSekulovic"}], "]"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<         k = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  \
ab \((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"48", "*", "a", "*", "b", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["\[Nu]", "2"]}], ")"}]}], 
        RowBox[{"Em", "*", 
         SuperscriptBox["h", "3"]}]], "*", "k"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<kSekulovic - k = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"kSekulovic", "-", "k"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Vektor", " ", "ekvivalentnog", " ", "opterecenje"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"IntegrandZaQ", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "Ni", "]"}], "*", "q"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Q = q\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{
      FractionBox["1", "q"], "*", 
      RowBox[{"Integrate", "[", 
       RowBox[{"IntegrandZaQ", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "dgZaX", ",", "ggZaX"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "dgZaY", ",", "ggZaY"}], "}"}]}], "]"}]}], "]"}]}],
    "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Exit", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.671285218561768*^9, 3.6712852224778795`*^9}, {
   3.6712853507781982`*^9, 3.6712853533627048`*^9}, {3.6712855156956444`*^9, 
   3.6712856569865522`*^9}, {3.67128569827171*^9, 3.6712858122335777`*^9}, {
   3.671285854529786*^9, 3.6712859397580795`*^9}, 3.671286029911565*^9, {
   3.67128621048756*^9, 3.671286417539914*^9}, {3.671286456937516*^9, 
   3.671286511641947*^9}, {3.6712865498084764`*^9, 3.671286641308779*^9}, {
   3.671286679408077*^9, 3.671286680392885*^9}, {3.6712868347312326`*^9, 
   3.6712870316508045`*^9}, {3.6712870631202908`*^9, 3.671287172719783*^9}, {
   3.671287218035914*^9, 3.6712872453120375`*^9}, {3.6712872857306986`*^9, 
   3.671287480913745*^9}, {3.67128760822691*^9, 3.671287615294515*^9}, {
   3.671287658983341*^9, 3.671287664085622*^9}, {3.671287720015352*^9, 
   3.6712878112462034`*^9}, {3.6712878430778933`*^9, 3.671288010857177*^9}, {
   3.6712880484430227`*^9, 3.6712880832353263`*^9}, {3.6712881190409427`*^9, 
   3.6712882842351017`*^9}, {3.671288322262892*^9, 3.6712886145514774`*^9}, {
   3.6712886499296465`*^9, 3.6712886964168*^9}, {3.6712887356531954`*^9, 
   3.6712887796809597`*^9}, {3.671288846683859*^9, 3.6712888540468025`*^9}, {
   3.671289010278998*^9, 3.6712890786229305`*^9}, {3.671289116596269*^9, 
   3.671289336057767*^9}, {3.6712893733520656`*^9, 3.6712894058850164`*^9}, {
   3.671289450951722*^9, 3.671289516751732*^9}, {3.6712895713626103`*^9, 
   3.6712897779221067`*^9}, {3.6712898803641434`*^9, 
   3.6712899069621696`*^9}, {3.6712900872947817`*^9, 3.671290110523388*^9}, {
   3.671290142906954*^9, 3.671290242433835*^9}, {3.6712907191559258`*^9, 
   3.6712907227028365`*^9}, {3.6712915529308906`*^9, 
   3.6712915541158876`*^9}, {3.6712915849831967`*^9, 
   3.6712915884658127`*^9}, {3.6712918668742604`*^9, 
   3.6712918948896437`*^9}, {3.6713638866615114`*^9, 
   3.6713639267959366`*^9}, {3.6713639654021297`*^9, 3.671364108649173*^9}, {
   3.671364163210293*^9, 3.671364170181383*^9}, 3.6713642026152887`*^9, 
   3.6713642576706853`*^9, {3.6713643072988725`*^9, 3.671364539558816*^9}, {
   3.671364580433095*^9, 3.6713645989780054`*^9}, {3.6713647080053787`*^9, 
   3.6713647472653875`*^9}, {3.6713647778689423`*^9, 3.6713647784323025`*^9}, 
   3.6713648706601353`*^9, {3.6713649157743363`*^9, 3.671364916136832*^9}, {
   3.6713649473896675`*^9, 3.671364998649497*^9}, {3.6713650955230904`*^9, 
   3.6713651050399957`*^9}, {3.671365304869897*^9, 3.6713653248734503`*^9}, {
   3.671365354956499*^9, 3.6713653614089217`*^9}, {3.671365396020467*^9, 
   3.671365431412361*^9}, {3.6713654780513506`*^9, 3.671365521483403*^9}, {
   3.6713656732056217`*^9, 3.6713659212539225`*^9}, {3.671426518830373*^9, 
   3.671426525233269*^9}, {3.6717741921281157`*^9, 3.671774212176962*^9}, {
   3.6717789587768874`*^9, 3.671779013165189*^9}, {3.6717791379871535`*^9, 
   3.671779186932439*^9}, {3.6717792438884296`*^9, 3.6717793035061707`*^9}, {
   3.671779347320695*^9, 3.671779450410405*^9}, {3.6717794989769335`*^9, 
   3.671779604387034*^9}, {3.671779661628614*^9, 3.671779707251586*^9}, {
   3.671779778085601*^9, 3.6717797983356867`*^9}, {3.6717799029052763`*^9, 
   3.6717799639934483`*^9}, {3.671780311972494*^9, 3.67178040856621*^9}, {
   3.671780639584324*^9, 3.6717807654167814`*^9}, {3.671780807517355*^9, 
   3.6717810976553736`*^9}, {3.6717811317585583`*^9, 3.671781206914386*^9}, {
   3.671781307239745*^9, 3.6717815025710073`*^9}, {3.671811932819356*^9, 
   3.6718122482552824`*^9}, {3.671812290688249*^9, 3.6718123623678527`*^9}, {
   3.671812420006447*^9, 3.671812446252369*^9}, {3.6718124774740324`*^9, 
   3.6718127818101397`*^9}, {3.6718128374554253`*^9, 3.67181294308043*^9}, {
   3.6718129769926376`*^9, 3.671813025462169*^9}, {3.6718130554713297`*^9, 
   3.6718132072752457`*^9}, {3.6718132726530647`*^9, 
   3.6718133742146673`*^9}, {3.6718134566132936`*^9, 3.671813580997898*^9}, {
   3.6718136154354467`*^9, 3.671813693988187*^9}, {3.671813739948841*^9, 
   3.671813787935314*^9}, {3.671813823417328*^9, 3.6718138250337043`*^9}, {
   3.6718138586745963`*^9, 3.671813895540545*^9}, {3.671814004842018*^9, 
   3.671814015478223*^9}, {3.6718199742193604`*^9, 3.6718200065635724`*^9}, {
   3.671820129618413*^9, 3.671820269119842*^9}, {3.671820338812415*^9, 
   3.6718203547218266`*^9}, {3.6718204023935676`*^9, 3.671820483971063*^9}, {
   3.671820584744954*^9, 3.6718206394933834`*^9}, {3.6718206805555696`*^9, 
   3.671820815156568*^9}, {3.6718208744598036`*^9, 3.6718209332828016`*^9}, {
   3.6718209668721514`*^9, 3.671820989211153*^9}, {3.671821061964681*^9, 
   3.671821111418125*^9}, {3.6718211845255175`*^9, 3.671821206509573*^9}, {
   3.6718212509793873`*^9, 3.6718215076635666`*^9}, {3.6718215393771024`*^9, 
   3.671821600321368*^9}, {3.6718216533057375`*^9, 3.671821663539055*^9}, {
   3.6718217255988903`*^9, 3.6718217759507914`*^9}, {3.6718218311602097`*^9, 
   3.6718218478347163`*^9}, {3.671821894305772*^9, 3.6718219297300587`*^9}, {
   3.6718221910898223`*^9, 3.6718222901567526`*^9}, {3.6718223518925424`*^9, 
   3.6718225175328913`*^9}, 3.671822579147814*^9, {3.67182269184648*^9, 
   3.6718228493494787`*^9}, {3.6718229830961466`*^9, 
   3.6718229872818766`*^9}, {3.6718230654528136`*^9, 3.671823141868691*^9}, {
   3.67182320143335*^9, 3.671823240288227*^9}, {3.6718232919420924`*^9, 
   3.671823308103662*^9}, {3.6718234025042424`*^9, 3.671823424530915*^9}, {
   3.6718236946353188`*^9, 3.6718237445504704`*^9}, {3.6718237783912354`*^9, 
   3.67182381086469*^9}, {3.6718239024213147`*^9, 3.6718239490975456`*^9}, {
   3.6718239959855213`*^9, 3.671824016390843*^9}, {3.6718240594319086`*^9, 
   3.671824124689901*^9}, {3.671824195488669*^9, 3.6718242009410715`*^9}, {
   3.6718242333409853`*^9, 3.671824252207259*^9}, {3.6718551784605937`*^9, 
   3.6718553262731314`*^9}, {3.6718553762594056`*^9, 
   3.6718554381127787`*^9}, {3.6718554853514585`*^9, 
   3.6718555283276367`*^9}, {3.671855593829836*^9, 3.671855603579984*^9}, {
   3.671855715187302*^9, 3.6718557398636*^9}, {3.6718557699019794`*^9, 
   3.6718557714182944`*^9}, {3.671855809941201*^9, 3.671855840050542*^9}, {
   3.6718559442812276`*^9, 3.6718559572800417`*^9}, {3.671856009468233*^9, 
   3.6718560570520725`*^9}, {3.671856101122105*^9, 3.6718561195348864`*^9}, {
   3.6718561626039658`*^9, 3.671856214746307*^9}, {3.671856272127247*^9, 
   3.6718562967772355`*^9}, 3.6718563310219126`*^9, {3.671856365488142*^9, 
   3.6718564155486126`*^9}, {3.671856458084223*^9, 3.671856474950062*^9}, {
   3.6718565060179415`*^9, 3.6718565467233124`*^9}, {3.671856613116184*^9, 
   3.671856653242087*^9}, {3.6718567121782827`*^9, 3.671856741618887*^9}, {
   3.6718567808982434`*^9, 3.6718569254495945`*^9}, {3.6718570757330837`*^9, 
   3.6718570855854588`*^9}, {3.6718571496350346`*^9, 
   3.6718571772586803`*^9}, {3.6718572291595306`*^9, 
   3.6718573207738256`*^9}, {3.6718574423460197`*^9, 3.671857466454465*^9}, {
   3.67185749711569*^9, 3.671857606936226*^9}, {3.671857655201708*^9, 
   3.671857686448434*^9}, {3.671857846702374*^9, 3.671857853955722*^9}, {
   3.67185788974846*^9, 3.671857900011544*^9}, {3.6718580239176764`*^9, 
   3.6718580246959057`*^9}, {3.671860089122366*^9, 3.671860175990391*^9}, {
   3.6718602160513296`*^9, 3.6718603397783556`*^9}, {3.6718604664273148`*^9, 
   3.6718605111823053`*^9}, {3.6718605670257945`*^9, 
   3.6718606463989315`*^9}, {3.6718606832246585`*^9, 3.6718606992270565`*^9}, 
   3.6718609088190937`*^9, {3.671860998007786*^9, 3.671861005307844*^9}, {
   3.6718617100985355`*^9, 3.671861714417272*^9}, {3.6718942709914985`*^9, 
   3.671894335625294*^9}, {3.6718949699354415`*^9, 3.671894970088913*^9}, {
   3.6718987476369715`*^9, 3.6718987483997793`*^9}, 3.6718989474868484`*^9, {
   3.671902181506486*^9, 3.6719022068810854`*^9}, {3.6719028263980923`*^9, 
   3.671902854322629*^9}, 3.6719521015513687`*^9, {3.6719830084599595`*^9, 
   3.671983021329599*^9}, {3.764850539337758*^9, 3.76485054025616*^9}, {
   3.764850635119614*^9, 3.7648507116432886`*^9}, 3.7648507719598923`*^9, 
   3.764850839990103*^9, {3.7648512978726315`*^9, 3.764851298837706*^9}, 
   3.764851811456026*^9, {3.7648525225664234`*^9, 3.7648526225140066`*^9}, {
   3.764852657875308*^9, 3.7648526590160475`*^9}, {3.7648527384406643`*^9, 
   3.7648527831957755`*^9}, {3.7648528351164117`*^9, 
   3.7648532582045083`*^9}, {3.764853356762643*^9, 3.7648534199999313`*^9}, {
   3.7648534522893753`*^9, 3.764853459246668*^9}, {3.764853492254261*^9, 
   3.764853543273456*^9}, {3.764853599536957*^9, 3.764853607188237*^9}, {
   3.76485376817686*^9, 3.7648538015875854`*^9}, {3.764853835567177*^9, 
   3.764853915326338*^9}, {3.7648539702145042`*^9, 3.764853971618474*^9}, {
   3.7648540847665024`*^9, 3.7648540857002497`*^9}, {3.7648542209112463`*^9, 
   3.7648542371406193`*^9}, {3.764854274005555*^9, 3.7648542931432734`*^9}, {
   3.764854323581976*^9, 3.764854444811792*^9}, 3.764854562667125*^9, 
   3.7648546292653484`*^9, {3.7648548581264105`*^9, 3.7648548601479225`*^9}, {
   3.7657752466623774`*^9, 3.7657752473325505`*^9}, {3.7658813395916853`*^9, 
   3.765881448289203*^9}, {3.765881488813991*^9, 3.765881556276971*^9}, {
   3.765882163004282*^9, 3.7658821652098007`*^9}, {3.7658823357784305`*^9, 
   3.765882406763747*^9}, {3.765882497851982*^9, 3.765882685234913*^9}, {
   3.7659513069574285`*^9, 3.7659513076216183`*^9}, 3.7659515949117403`*^9, {
   3.7686433368596773`*^9, 3.768643345823449*^9}, {3.7888683350258455`*^9, 
   3.788868375576277*^9}, {3.78886841172418*^9, 3.788868427260683*^9}, {
   3.7888691907912993`*^9, 3.7888692010860343`*^9}, {3.788869835867634*^9, 
   3.7888698712882147`*^9}, {3.7888712404301295`*^9, 
   3.7888713105880127`*^9}, {3.7888713832481165`*^9, 
   3.7888714096363935`*^9}, {3.788871445963838*^9, 3.788871454895713*^9}, {
   3.788875011781168*^9, 3.7888750166433363`*^9}, {3.788875091226059*^9, 
   3.7888753903779535`*^9}, {3.788875424680818*^9, 3.788875458243658*^9}, {
   3.788875549741234*^9, 3.7888755925845265`*^9}, {3.7888756459069138`*^9, 
   3.788875648762*^9}, {3.7888757070779734`*^9, 3.7888757421371164`*^9}, {
   3.788875803540922*^9, 3.788875855002714*^9}, {3.7888759030099225`*^9, 
   3.7888759293119535`*^9}, {3.7888759694250717`*^9, 
   3.7888759818829727`*^9}, {3.788876033942625*^9, 3.7888760342602825`*^9}, {
   3.788876092120573*^9, 3.78887613288743*^9}, {3.788876175376999*^9, 
   3.78887625555857*^9}, 3.7888763669045854`*^9, {3.7888764125905514`*^9, 
   3.788876821599981*^9}, {3.7888768539380307`*^9, 3.788876937039981*^9}, {
   3.788876978329454*^9, 3.7888769976538086`*^9}, {3.78887703002542*^9, 
   3.7888772036665*^9}, {3.7888772573958917`*^9, 3.7888774867392893`*^9}, {
   3.788878060292031*^9, 3.7888780849149446`*^9}, {3.788878116869171*^9, 
   3.7888782320923886`*^9}, {3.788878266245311*^9, 3.7888784384288692`*^9}, {
   3.78887849478141*^9, 3.7888785117391*^9}, {3.788878600777542*^9, 
   3.7888787355454855`*^9}, {3.788878805788706*^9, 3.7888788594279146`*^9}, {
   3.788878937411618*^9, 3.788878993699915*^9}, {3.788879044385849*^9, 
   3.7888790570286493`*^9}, {3.7889277027066326`*^9, 3.78892774620237*^9}, {
   3.7889280701483192`*^9, 3.788928141080653*^9}, {3.7889281827532663`*^9, 
   3.788928193720052*^9}, {3.78892826653611*^9, 3.7889283048322763`*^9}, {
   3.7889284990179915`*^9, 3.7889284995061855`*^9}, {3.788928586159482*^9, 
   3.788928624278353*^9}, {3.78892865966041*^9, 3.78892871630365*^9}, {
   3.788929867846249*^9, 3.7889298684112325`*^9}, {3.788930262719632*^9, 
   3.7889305267227263`*^9}, {3.7889306147870703`*^9, 
   3.7889306604723024`*^9}, {3.7889307132712784`*^9, 3.788930756268108*^9}, {
   3.7889307903948064`*^9, 3.7889307939007564`*^9}, {3.7889308523866963`*^9, 
   3.7889309434564586`*^9}, {3.788931030425323*^9, 3.788931162231959*^9}, {
   3.7889312823834467`*^9, 3.7889312840554113`*^9}, {3.788931315585106*^9, 
   3.7889314880972548`*^9}, {3.7889315182746763`*^9, 3.788931626692915*^9}, {
   3.7889316638505125`*^9, 3.788931695556734*^9}, {3.788931750353458*^9, 
   3.7889317937618065`*^9}, {3.7889318657636456`*^9, 3.788932122897314*^9}, {
   3.788932208111255*^9, 3.7889322593392577`*^9}, {3.7889323170669365`*^9, 
   3.788932346935416*^9}, {3.7889324258400745`*^9, 3.788932427028426*^9}, {
   3.7889325116645536`*^9, 3.7889325652719326`*^9}, {3.788932601249574*^9, 
   3.7889326295904965`*^9}, 3.788932663515993*^9, {3.7889327225289545`*^9, 
   3.7889327371778603`*^9}, {3.7889327728234186`*^9, 
   3.7889327908741307`*^9}, {3.7889328826694326`*^9, 
   3.7889329132232895`*^9}, {3.7889330725275407`*^9, 
   3.7889330731056595`*^9}, {3.7889331032253304`*^9, 
   3.7889331051471972`*^9}, {3.7889336873689585`*^9, 3.788933860702362*^9}, {
   3.7889339034640613`*^9, 3.788934030376363*^9}, {3.7889340697034044`*^9, 
   3.7889341099545465`*^9}, {3.788934149700876*^9, 3.7889342132389355`*^9}, {
   3.788934264848363*^9, 3.7889342830738583`*^9}, {3.7889343132574725`*^9, 
   3.788934614429613*^9}, {3.788934663501567*^9, 3.788934686694477*^9}, {
   3.7889347411103125`*^9, 3.7889347925621305`*^9}, 3.7889348356393414`*^9, {
   3.788934880140425*^9, 3.7889348938515415`*^9}, {3.788934939486585*^9, 
   3.788935082930088*^9}, {3.7889351211501803`*^9, 3.7889351408905783`*^9}, 
   3.7889351741547246`*^9, {3.788935252884767*^9, 3.788935342188068*^9}, {
   3.7889354425502276`*^9, 3.788935490909715*^9}, {3.788935546590757*^9, 
   3.788935598585597*^9}, {3.788935745258687*^9, 3.7889358353096666`*^9}, {
   3.7889358756468916`*^9, 3.788935941789583*^9}, {3.788935973524351*^9, 
   3.7889360682046227`*^9}, {3.7889360994055986`*^9, 
   3.7889361965614214`*^9}, {3.788936229416624*^9, 3.788936281779401*^9}, {
   3.7889363167117624`*^9, 3.78893631727426*^9}, {3.788936350325221*^9, 
   3.7889363547881804`*^9}, 3.7889364043104343`*^9, {3.788936468283768*^9, 
   3.788936472783749*^9}, {3.788936550841318*^9, 3.7889365917246265`*^9}, {
   3.788936624923196*^9, 3.7889366623949423`*^9}, {3.788936713039298*^9, 
   3.7889367238542137`*^9}, 3.7889368492799854`*^9, {3.7889369499518933`*^9, 
   3.7889369500925183`*^9}, {3.788936983017535*^9, 3.7889370718366346`*^9}, {
   3.7889371058205967`*^9, 3.788937109070583*^9}, 3.7889372314799876`*^9, {
   3.7889373144715014`*^9, 3.7889374040086536`*^9}, {3.7889374377889977`*^9, 
   3.7889375105223885`*^9}, {3.7889375755687256`*^9, 
   3.7889376237265973`*^9}, {3.788937697449001*^9, 3.7889377313929405`*^9}, {
   3.788937814713395*^9, 3.7889378496023054`*^9}, {3.788937916908702*^9, 
   3.78893794647971*^9}, {3.7889379933369236`*^9, 3.7889380774623194`*^9}, {
   3.7889385634986362`*^9, 3.788938584419098*^9}, {3.788938642662367*^9, 
   3.7889387175439806`*^9}, {3.78893875173489*^9, 3.788938823010933*^9}, 
   3.788938853674123*^9, {3.7889388881523705`*^9, 3.7889389207902775`*^9}, {
   3.788938994410183*^9, 3.788939000930122*^9}, {3.7889390906451716`*^9, 
   3.788939103344173*^9}, {3.7889391357277517`*^9, 3.788939246151387*^9}, {
   3.7889393046677485`*^9, 3.7889393764003906`*^9}, {3.7889394113789015`*^9, 
   3.788939457843468*^9}, {3.7889395135611067`*^9, 3.7889397004651575`*^9}, {
   3.788939750862116*^9, 3.788939867939757*^9}, {3.788939905089368*^9, 
   3.7889399744039097`*^9}, {3.7889400251977015`*^9, 3.788940088711226*^9}, {
   3.7889401356048317`*^9, 3.7889401596426983`*^9}, {3.788940221678084*^9, 
   3.7889402299874115`*^9}, {3.788940266193453*^9, 3.788940266740344*^9}, {
   3.788940460823142*^9, 3.7889405816799746`*^9}, {3.7889406123770475`*^9, 
   3.7889408309900866`*^9}, {3.788940874956951*^9, 3.7889409673805532`*^9}, {
   3.7889410318378477`*^9, 3.788941047106982*^9}, {3.7889410866515417`*^9, 
   3.788941106266632*^9}, {3.7889411702337947`*^9, 3.7889412104324627`*^9}, {
   3.788941249957552*^9, 3.78894128222021*^9}, {3.788941320337202*^9, 
   3.788941416522251*^9}, {3.788941490738638*^9, 3.7889414908306336`*^9}, {
   3.7889415298528266`*^9, 3.788941678410945*^9}, {3.7889417129325294`*^9, 
   3.788941788358096*^9}, {3.7889418468701725`*^9, 3.788941855901862*^9}, {
   3.7889420651805534`*^9, 3.7889421161174326`*^9}, {3.7889421474732027`*^9, 
   3.7889422577717943`*^9}, {3.788942303617524*^9, 3.7889424714791937`*^9}, {
   3.788942519320487*^9, 3.788942594647809*^9}, {3.7889426356570315`*^9, 
   3.7889426692096815`*^9}, {3.788942703217082*^9, 3.78894270651571*^9}, {
   3.788942754963399*^9, 3.788942788869017*^9}, {3.7889428225684185`*^9, 
   3.7889430646928864`*^9}, {3.788943292588423*^9, 3.7889433432983217`*^9}, {
   3.7889448499168944`*^9, 3.7889448985276546`*^9}, {3.788944936174612*^9, 
   3.788944945156077*^9}, {3.7889449772776623`*^9, 3.7889450176829185`*^9}, {
   3.7889450663171453`*^9, 3.7889452744140944`*^9}, {3.7889453132757463`*^9, 
   3.7889455905750628`*^9}, {3.7889456691017303`*^9, 3.788945744113161*^9}, {
   3.7889458012545357`*^9, 3.788945850892818*^9}, {3.7889459012495317`*^9, 
   3.7889460897136855`*^9}, {3.7889461526720867`*^9, 3.788946265544243*^9}, {
   3.788946305278676*^9, 3.788946330675517*^9}, {3.7889463633885746`*^9, 
   3.7889464337150946`*^9}, {3.788946500555638*^9, 3.788946551090985*^9}, {
   3.788946607516986*^9, 3.7889467505657225`*^9}, 3.7889467892684407`*^9, {
   3.7889468444326906`*^9, 3.7889468456202016`*^9}, 3.788946879327982*^9, {
   3.788946967481017*^9, 3.7889471081995664`*^9}, {3.788947211933799*^9, 
   3.788947344984446*^9}, {3.7889473811507883`*^9, 3.7889474765330505`*^9}, {
   3.788947545103493*^9, 3.788947548684409*^9}, {3.789023061008133*^9, 
   3.7890232181868067`*^9}, {3.789023349713216*^9, 3.7890234902202873`*^9}, {
   3.7890235513195314`*^9, 3.7890235609296155`*^9}, {3.7890236002351155`*^9, 
   3.7890236611514444`*^9}, {3.7890238415336933`*^9, 3.789023864943338*^9}, {
   3.789023910818262*^9, 3.7890239198446064`*^9}, 3.7890241520480905`*^9, {
   3.7890241937357283`*^9, 3.789024335991862*^9}, {3.7890243854397326`*^9, 
   3.789024437110846*^9}, {3.7890245319719687`*^9, 3.7890245528745394`*^9}, {
   3.789024651954897*^9, 3.7890246989480934`*^9}, {3.7890247681577177`*^9, 
   3.789024780584651*^9}, {3.789024819295697*^9, 3.789024841085168*^9}, {
   3.789024876726943*^9, 3.789025071435512*^9}, {3.789025109168145*^9, 
   3.78902521049349*^9}, {3.789025326046049*^9, 3.7890253613823905`*^9}, {
   3.7890253995219755`*^9, 3.789025473728295*^9}, {3.789025509692209*^9, 
   3.789025560624873*^9}, {3.7890256437284265`*^9, 3.7890256442987905`*^9}, {
   3.789025699377643*^9, 3.7890257192177715`*^9}, 3.7890257537080913`*^9, {
   3.789025829125077*^9, 3.7890258334942102`*^9}, {3.7890260353542414`*^9, 
   3.7890260913879347`*^9}, {3.789026122237811*^9, 3.789026184378585*^9}, {
   3.789026236255331*^9, 3.789026296185978*^9}, {3.789026348791497*^9, 
   3.789026350982068*^9}, {3.789026388246945*^9, 3.7890263937229595`*^9}, {
   3.789026503954151*^9, 3.7890265773010025`*^9}, {3.789026610673023*^9, 
   3.7890266517928057`*^9}, {3.789026682706566*^9, 3.7890266929331837`*^9}, {
   3.7890267361999865`*^9, 3.7890267750484004`*^9}, {3.789026809354734*^9, 
   3.7890268472747054`*^9}, 3.7890269392315044`*^9, {3.7890269738174143`*^9, 
   3.7890270380120773`*^9}, {3.7890273573663845`*^9, 3.789027370153887*^9}, {
   3.789027408118063*^9, 3.7890274160788717`*^9}, {3.789027525128593*^9, 
   3.78902764598519*^9}, {3.789027677587797*^9, 3.78902772035088*^9}, {
   3.789027752076336*^9, 3.789027784393772*^9}, {3.7890278421195297`*^9, 
   3.789027848467891*^9}, {3.789027879366764*^9, 3.7890279162985106`*^9}, {
   3.7890279961287107`*^9, 3.7890280169665985`*^9}, {3.789028107735612*^9, 
   3.7890281128645277`*^9}, {3.789028147381074*^9, 3.7890282385724897`*^9}, {
   3.7890282725633082`*^9, 3.789028344810417*^9}, {3.7890283755451946`*^9, 
   3.789028450977661*^9}, {3.7890285031852913`*^9, 3.789028544713812*^9}, {
   3.7890324643380632`*^9, 3.7890325758188767`*^9}, {3.789032641633298*^9, 
   3.7890327427016582`*^9}, {3.7890328770077715`*^9, 3.78903307560835*^9}, {
   3.7890359318106427`*^9, 3.789035932008642*^9}, {3.7890379486146765`*^9, 
   3.789037949617454*^9}, {3.7890389089036064`*^9, 3.7890389245012107`*^9}, {
   3.7890390222777205`*^9, 3.789039032151469*^9}, {3.789039188247497*^9, 
   3.7890392652095337`*^9}, 3.7890394915092936`*^9, {3.7890400346546144`*^9, 
   3.78904005785102*^9}, {3.789042512727436*^9, 3.789042514015156*^9}, {
   3.789482782714414*^9, 3.7894827829331636`*^9}, {3.790843725813648*^9, 
   3.7908437749356413`*^9}, {3.790843945040861*^9, 3.7908441005349083`*^9}, {
   3.79084469742492*^9, 3.790844761357546*^9}, {3.7908449665374513`*^9, 
   3.7908449991981263`*^9}, {3.7908450309699793`*^9, 3.7908450502061787`*^9}, 
   3.7908451050400906`*^9, {3.7908451810277057`*^9, 3.7908451912383113`*^9}, {
   3.7908459034609966`*^9, 3.7908459507545223`*^9}, {3.7908461176431317`*^9, 
   3.7908461179595385`*^9}, {3.7908466019254465`*^9, 
   3.7908467198173857`*^9}, {3.7908468888399305`*^9, 3.790846934048202*^9}, {
   3.7908469712347713`*^9, 3.7908469716893024`*^9}, {3.7909079051042857`*^9, 
   3.7909079427643685`*^9}, {3.7909079922911572`*^9, 
   3.7909080021969166`*^9}, {3.790909985821327*^9, 3.790909988130271*^9}, {
   3.79091015267225*^9, 3.790910157717128*^9}, {3.790910376527751*^9, 
   3.790910397554235*^9}, {3.7909104284624796`*^9, 3.79091042966345*^9}, {
   3.7909105061275826`*^9, 3.790910544646642*^9}, 3.790910636663686*^9, {
   3.7909116893537993`*^9, 3.790911796894176*^9}, {3.7909118802965746`*^9, 
   3.7909119918098526`*^9}, {3.7909120472064967`*^9, 
   3.7909120518163867`*^9}, {3.790912083556612*^9, 3.7909122484765854`*^9}, {
   3.79091234368426*^9, 3.790912353491021*^9}, {3.79091250411734*^9, 
   3.7909125842433834`*^9}, {3.7909127387521677`*^9, 
   3.7909127967417574`*^9}, {3.790912993990937*^9, 3.790913023057994*^9}, {
   3.790913412647771*^9, 3.7909134167226667`*^9}, {3.7909134797871275`*^9, 
   3.790913489289897*^9}, {3.790917982265809*^9, 3.7909180243917828`*^9}, {
   3.790918108393732*^9, 3.790918180655965*^9}, {3.7909182264284935`*^9, 
   3.7909182440050645`*^9}, 3.790918318495246*^9, {3.7909183997362394`*^9, 
   3.790918458373805*^9}, {3.7909185646572123`*^9, 3.7909186324525566`*^9}, {
   3.790918679539407*^9, 3.7909188176440372`*^9}, {3.7909188550291224`*^9, 
   3.7909189021979685`*^9}, {3.790918942972975*^9, 3.7909189557166643`*^9}, {
   3.790919174693166*^9, 3.7909192475123887`*^9}, {3.7909193247367444`*^9, 
   3.7909193449602547`*^9}, {3.790919424704063*^9, 3.7909196150214195`*^9}, {
   3.7909196532074847`*^9, 3.7909196939474926`*^9}, {3.7909197945770335`*^9, 
   3.7909198069617333`*^9}, {3.7910160031863527`*^9, 3.791016018185157*^9}, {
   3.791016062809433*^9, 3.7910161733526535`*^9}, {3.7910162489452024`*^9, 
   3.7910162987569733`*^9}, 3.7910164041088047`*^9, 3.7910164598809657`*^9, {
   3.791016530198585*^9, 3.791016559444867*^9}, 3.791016615540489*^9, 
   3.7910166538957453`*^9, {3.7910167292092323`*^9, 3.791016809833393*^9}, {
   3.791016842714589*^9, 3.791016852083356*^9}, {3.791016925933322*^9, 
   3.791016955775276*^9}, {3.7910170628158436`*^9, 3.791017083568331*^9}, {
   3.7910172299547367`*^9, 3.7910172379405346`*^9}, {3.791017374516403*^9, 
   3.7910173867051*^9}, {3.7910185663183537`*^9, 3.7910185712192326`*^9}, {
   3.791018693041989*^9, 3.791018695316489*^9}, {3.7910187332527747`*^9, 
   3.791018842077097*^9}, {3.7910188791347103`*^9, 3.7910189053010674`*^9}, {
   3.791018955733124*^9, 3.7910189656588764`*^9}, {3.7910191941184196`*^9, 
   3.7910192183738227`*^9}, 3.791019260597212*^9, {3.791019295282355*^9, 
   3.791019295844343*^9}, {3.791089516569024*^9, 3.7910895229836683`*^9}, {
   3.7910896983826494`*^9, 3.7910897798056135`*^9}, 3.7910903537254095`*^9, {
   3.791090447668702*^9, 3.7910905437563124`*^9}, {3.791090585582284*^9, 
   3.7910905949060497`*^9}, {3.791090630341486*^9, 3.791090711377494*^9}, {
   3.7910908160329647`*^9, 3.791090816777946*^9}, {3.7910908939438047`*^9, 
   3.791090903904558*^9}, {3.791098107725418*^9, 3.7910982165441127`*^9}, {
   3.7910983423446846`*^9, 3.791098342719671*^9}, {3.7910995084959235`*^9, 
   3.7910995787372026`*^9}, {3.7911001164609833`*^9, 
   3.7911003039604096`*^9}, {3.7911003371110992`*^9, 3.791100355140659*^9}, {
   3.7911003874068613`*^9, 3.7911004045214443`*^9}, {3.7911004584201727`*^9, 
   3.7911004994401646`*^9}, {3.7911006691861944`*^9, 
   3.7911006732560973`*^9}, {3.7911007387078953`*^9, 3.7911007605713577`*^9}, 
   3.7911008258159018`*^9, {3.791130562502917*^9, 3.7911305654264016`*^9}, {
   3.791206779717471*^9, 3.7912067882934227`*^9}, {3.791206886689635*^9, 
   3.7912069198875313`*^9}, {3.7912069635058904`*^9, 3.791207137956523*^9}, {
   3.7912071740064135`*^9, 3.7912072356832037`*^9}, {3.791207305674878*^9, 
   3.7912073266311374`*^9}, {3.7912095339422607`*^9, 3.791209669160851*^9}, {
   3.7912097079191923`*^9, 3.791209764978924*^9}, {3.7912098169137893`*^9, 
   3.791209821155846*^9}, {3.79120988676807*^9, 3.791209887215577*^9}, {
   3.791210055646822*^9, 3.7912100766490993`*^9}, {3.7912101250334845`*^9, 
   3.7912101602162066`*^9}, {3.791210205081773*^9, 3.7912102491041346`*^9}, {
   3.791210281488631*^9, 3.7912103087433558`*^9}, {3.791210387556986*^9, 
   3.791210427098445*^9}, {3.7912104851834445`*^9, 3.7912105339448347`*^9}, {
   3.7912105692360926`*^9, 3.791210888207255*^9}, {3.791211001858008*^9, 
   3.7912110073777456`*^9}, 3.7912110779936914`*^9, {3.791341730267441*^9, 
   3.7913417419214973`*^9}, {3.7913417853146534`*^9, 3.791341798033826*^9}, {
   3.7913595355926447`*^9, 3.7913596023199396`*^9}, {3.791359651552575*^9, 
   3.7913597062433863`*^9}, {3.7913597434718823`*^9, 
   3.7913597740218496`*^9}, {3.7913598126023602`*^9, 3.791359862306981*^9}, {
   3.7913599027928705`*^9, 3.791359926202795*^9}, {3.7913599696895533`*^9, 
   3.791359969921548*^9}, {3.791528747219673*^9, 3.791528827929741*^9}, {
   3.7915288968390913`*^9, 3.7915289702003355`*^9}, {3.791531227788316*^9, 
   3.7915312723522496`*^9}, {3.791532430345541*^9, 3.7915324363043985`*^9}, 
   3.7917154946725683`*^9, {3.7917175987352476`*^9, 3.791717633265417*^9}, {
   3.7917176903000317`*^9, 3.7917179844329023`*^9}, {3.7917191493886623`*^9, 
   3.7917191998544416`*^9}, {3.791719317619587*^9, 3.7917193211025004`*^9}, {
   3.791719928883767*^9, 3.7917199393315153`*^9}, {3.7957548018328953`*^9, 
   3.7957548063363485`*^9}, {3.795754860283549*^9, 3.795754913860543*^9}, {
   3.795755150231192*^9, 3.79575519109721*^9}, 3.7957596917437315`*^9, {
   3.7957630356819925`*^9, 3.7957631581314607`*^9}, {3.795763191648449*^9, 
   3.7957632062818837`*^9}, {3.795763254054517*^9, 3.7957635629879074`*^9}, {
   3.7957635932105894`*^9, 3.7957636402507353`*^9}, {3.79576368573678*^9, 
   3.795763720682663*^9}, {3.795763766511769*^9, 3.795763769619953*^9}, {
   3.7957638732782235`*^9, 3.7957639291335125`*^9}, {3.795764624324218*^9, 
   3.7957646704796534`*^9}, {3.795765312251685*^9, 3.795765359180357*^9}, {
   3.7957654467878513`*^9, 3.7957655671986203`*^9}, 3.7957658293884945`*^9, {
   3.795765867194005*^9, 3.7957659136449275`*^9}, {3.795765951493539*^9, 
   3.7957660221247354`*^9}, {3.795766053661808*^9, 3.7957660730813913`*^9}, {
   3.795766104208826*^9, 3.795766156335266*^9}, {3.795766449773095*^9, 
   3.795766472689904*^9}, {3.7957665163790026`*^9, 3.79576651836697*^9}, {
   3.795766588265171*^9, 3.7957667325250793`*^9}, {3.7957667651108103`*^9, 
   3.795766782491742*^9}, {3.7957668451380353`*^9, 3.7957670031328917`*^9}, {
   3.7957670377565155`*^9, 3.7957672935771894`*^9}, {3.795767332508377*^9, 
   3.7957674147450047`*^9}, {3.7957674498424683`*^9, 
   3.7957674538785257`*^9}, {3.795767533730137*^9, 3.7957675827453766`*^9}, {
   3.79576787561344*^9, 3.795767931931361*^9}, {3.7957679927792325`*^9, 
   3.7957680447019367`*^9}, {3.7957680786368155`*^9, 
   3.7957681038964148`*^9}, {3.795768206520502*^9, 3.795768308065339*^9}, 
   3.795768347128091*^9, {3.795768405206871*^9, 3.795768514941247*^9}, {
   3.7957685515331583`*^9, 3.7957687686143875`*^9}, {3.7957689141007204`*^9, 
   3.7957689967894707`*^9}, {3.7957690322525854`*^9, 3.795769349545371*^9}, {
   3.795769397987958*^9, 3.7957694845200367`*^9}, {3.7957695150814095`*^9, 
   3.795769608321438*^9}, {3.795769657619445*^9, 3.7957696972894707`*^9}, {
   3.7957697364309797`*^9, 3.7957697852724457`*^9}, {3.7957698836421747`*^9, 
   3.7957699220579534`*^9}, {3.7957699632501287`*^9, 3.79577011349559*^9}, {
   3.7957701731243*^9, 3.79577020103985*^9}, {3.7957703590603456`*^9, 
   3.7957703816217833`*^9}, {3.795770447424009*^9, 3.7957706635726395`*^9}, {
   3.795770704243224*^9, 3.7957707412307463`*^9}, {3.795770780366226*^9, 
   3.795771277607514*^9}, {3.7957713965399933`*^9, 3.7957716165039053`*^9}, {
   3.7957716803744946`*^9, 3.7957716859142723`*^9}, {3.795771745710188*^9, 
   3.7957718141393323`*^9}, {3.795771866466683*^9, 3.7957718754812183`*^9}, {
   3.7957719207626877`*^9, 3.7957721314769316`*^9}, {3.795772225572294*^9, 
   3.7957723474468904`*^9}, {3.7957724058312545`*^9, 
   3.7957724817635756`*^9}, {3.795772936497026*^9, 3.7957729695197954`*^9}, {
   3.795774048751607*^9, 3.7957740540597687`*^9}, {3.795774137698264*^9, 
   3.795774139903577*^9}, {3.7957752870636816`*^9, 3.7957752895386343`*^9}, {
   3.795775368170969*^9, 3.7957754204924*^9}, {3.795775524705474*^9, 
   3.7957755277508373`*^9}, {3.795775730935516*^9, 3.795776148857689*^9}, {
   3.7957846978938255`*^9, 3.7957848156092863`*^9}, {3.7957853964794273`*^9, 
   3.7957854643675113`*^9}, {3.7957855896566916`*^9, 3.795785655892604*^9}, {
   3.7957857105518637`*^9, 3.7957857842745895`*^9}, {3.795786022258541*^9, 
   3.795786171072488*^9}, {3.7957862488534393`*^9, 3.7957862503571873`*^9}, {
   3.7957864455915804`*^9, 3.795786478518635*^9}, {3.7957866425835657`*^9, 
   3.7957866481785183`*^9}, {3.79578676085824*^9, 3.7957868252289886`*^9}, {
   3.7957869232880692`*^9, 3.7957869273789883`*^9}, {3.79578722131587*^9, 
   3.795787263696974*^9}, {3.7957879668959465`*^9, 3.7957879704849305`*^9}, {
   3.7957882181097937`*^9, 3.795788352599945*^9}, {3.7957883870913954`*^9, 
   3.7957884179317513`*^9}, {3.7957885632269874`*^9, 
   3.7957885636338696`*^9}, {3.7957898502934675`*^9, 
   3.7957898604686375`*^9}, {3.7957904103732953`*^9, 3.795790535907909*^9}, {
   3.7957912117742558`*^9, 3.795791232231426*^9}, {3.795799727317109*^9, 
   3.795799743735979*^9}, {3.795799810064398*^9, 3.7957998622494946`*^9}, {
   3.795799947493413*^9, 3.7957999643696365`*^9}, {3.795800029364397*^9, 
   3.795800030482961*^9}, {3.7958000886244783`*^9, 3.7958003355255017`*^9}, {
   3.7958012365720587`*^9, 3.7958012543199167`*^9}, 3.7958012997589736`*^9, {
   3.7958043578497887`*^9, 3.79580437750241*^9}, {3.7958359422536707`*^9, 
   3.7958359780394564`*^9}, {3.7958361728660693`*^9, 
   3.7958361748864455`*^9}, {3.7958362229624405`*^9, 3.795836224728586*^9}, {
   3.795836262790661*^9, 3.7958363258410177`*^9}, {3.7958373101756053`*^9, 
   3.7958373454379563`*^9}, {3.795837376049483*^9, 3.7958374374638205`*^9}, {
   3.7958374817763653`*^9, 3.795837618634675*^9}, {3.7958376890827527`*^9, 
   3.795837731459598*^9}, {3.795837791261067*^9, 3.795837891277508*^9}, {
   3.7958379397045317`*^9, 3.7958379546348023`*^9}, {3.795838035318288*^9, 
   3.7958380869703417`*^9}, {3.7958382985824785`*^9, 3.795838393684393*^9}, {
   3.7958386249712563`*^9, 3.795838672558491*^9}, {3.7958387358601713`*^9, 
   3.795839023005782*^9}, {3.7958390582343674`*^9, 3.795839092852316*^9}, {
   3.7958392240706625`*^9, 3.7958392895377007`*^9}, {3.795839335177641*^9, 
   3.7958393688826876`*^9}, {3.7958395030270777`*^9, 3.795839511760705*^9}, {
   3.7958396944471617`*^9, 3.7958397075615215`*^9}, {3.795839762662679*^9, 
   3.7958398462072906`*^9}, {3.7958398861953897`*^9, 
   3.7958398883188906`*^9}, {3.7958403718541913`*^9, 3.795840603729397*^9}, 
   3.7958406386065617`*^9, {3.7958407344927273`*^9, 3.7958408756690836`*^9}, {
   3.7958409575556755`*^9, 3.795841055270795*^9}, 3.7958411019797573`*^9, {
   3.7958411464585075`*^9, 3.7958411902539825`*^9}, {3.795841373768772*^9, 
   3.7958413746075954`*^9}, {3.795841501852187*^9, 3.7958416942012053`*^9}, {
   3.7958420084658527`*^9, 3.7958420642461796`*^9}, {3.795842187797064*^9, 
   3.7958422263232465`*^9}, {3.7958422894334354`*^9, 3.7958423745157833`*^9}, 
   3.7958424653336177`*^9, {3.79584270370002*^9, 3.795843191161976*^9}, {
   3.795843242923383*^9, 3.79584326528629*^9}, {3.7958433332785697`*^9, 
   3.795843445331512*^9}, {3.7958434770355377`*^9, 3.7958434969723845`*^9}, {
   3.7958437937725234`*^9, 3.795843892498868*^9}, {3.7958441815004606`*^9, 
   3.795844193116521*^9}, 3.7958442711536965`*^9, {3.7958443131605644`*^9, 
   3.7958443366880255`*^9}, {3.7958445578603935`*^9, 3.795844567881683*^9}, {
   3.795844609422711*^9, 3.7958446735770493`*^9}, {3.7958448392678785`*^9, 
   3.7958448409564095`*^9}, {3.7958451236201854`*^9, 
   3.7958451247226925`*^9}, {3.7958451750576563`*^9, 
   3.7958452048178535`*^9}, {3.795845294099509*^9, 3.79584531950994*^9}, {
   3.795845745598257*^9, 3.795845785442645*^9}, {3.795845816041978*^9, 
   3.795845857902256*^9}, {3.79584589500029*^9, 3.7958459045817723`*^9}, {
   3.7958459679720373`*^9, 3.79584596831977*^9}, {3.795847527238681*^9, 
   3.7958475742997932`*^9}, 3.7958491124196167`*^9, {3.7958509780004263`*^9, 
   3.795851039764656*^9}, {3.7958618902321615`*^9, 3.795861947569424*^9}, 
   3.7959701322298813`*^9, {3.7960321438838573`*^9, 3.7960322304412813`*^9}, {
   3.796032391270464*^9, 3.7960324796372323`*^9}, {3.7960325397116814`*^9, 
   3.796032545373929*^9}, {3.796034196756991*^9, 3.796034216844303*^9}, {
   3.7960432604391594`*^9, 3.7960433527024345`*^9}, 3.796043401901026*^9, {
   3.7960434436020575`*^9, 3.796043481405795*^9}, {3.7960436492508435`*^9, 
   3.796043655367264*^9}, {3.7960436975142183`*^9, 3.796043749389515*^9}, {
   3.796043782248665*^9, 3.796043791003408*^9}, {3.7960438342690783`*^9, 
   3.7960438356151824`*^9}, {3.796043873605925*^9, 3.79604388839228*^9}, {
   3.79604395865932*^9, 3.796044126145952*^9}, {3.7960441634198465`*^9, 
   3.7960444828949966`*^9}, {3.7960445559177485`*^9, 3.796044613891962*^9}, {
   3.796044743784566*^9, 3.796044827517874*^9}, {3.7960450959709883`*^9, 
   3.7960452943959875`*^9}, 3.796045363176977*^9, {3.796045402566487*^9, 
   3.796045728814279*^9}, {3.7960939382163873`*^9, 3.796093967765274*^9}, {
   3.796094110763457*^9, 3.796094116563496*^9}, {3.796094503496435*^9, 
   3.7960945239830976`*^9}, {3.796095847416685*^9, 3.796095866796022*^9}, {
   3.796096218310032*^9, 3.796096229518111*^9}, {3.7960963346529517`*^9, 
   3.79609639702041*^9}, {3.796096624076439*^9, 3.7960966297655563`*^9}, {
   3.7960966755581875`*^9, 3.796096781055234*^9}, 3.796096830464864*^9, {
   3.796097145752301*^9, 3.796097146689802*^9}, {3.7961094157045603`*^9, 
   3.796109553288597*^9}, {3.7961095924593983`*^9, 3.7961097381125383`*^9}, {
   3.796109779627802*^9, 3.7961098614395437`*^9}, 3.796109935425497*^9, {
   3.796111434593335*^9, 3.796111522463137*^9}, {3.796111561469472*^9, 
   3.7961116838193207`*^9}, {3.796145388738308*^9, 3.7961454069136915`*^9}, {
   3.796147110711898*^9, 3.7961471181787305`*^9}, {3.7961477245464087`*^9, 
   3.796147805039276*^9}, {3.796148865546574*^9, 3.7961489226972747`*^9}, {
   3.79614898564361*^9, 3.796149028157853*^9}, 3.7961502669710245`*^9, {
   3.796151366096759*^9, 3.796151385948673*^9}, {3.7961514253812675`*^9, 
   3.7961514781305933`*^9}, 3.7961529576314774`*^9, {3.7961891911738153`*^9, 
   3.796189193016626*^9}, {3.7961892317994795`*^9, 3.7961892942713776`*^9}, {
   3.7961919728682833`*^9, 3.796191996079544*^9}, {3.796192045701928*^9, 
   3.796192204486471*^9}, 3.7961922738131466`*^9, {3.796192310824662*^9, 
   3.796192371661187*^9}, {3.796192421883441*^9, 3.7961924764207225`*^9}, {
   3.7961925196414785`*^9, 3.7961925991464524`*^9}, {3.7961927933821845`*^9, 
   3.79619304049835*^9}, {3.796193081292365*^9, 3.796193112323227*^9}, {
   3.7963555737445073`*^9, 3.796355797308956*^9}, {3.7963558518428116`*^9, 
   3.7963562275420666`*^9}, {3.796356278284442*^9, 3.7963563006605453`*^9}, {
   3.796356387887001*^9, 3.796356543621484*^9}, {3.796356611462432*^9, 
   3.796356729612837*^9}, {3.7963567601082044`*^9, 3.7963571927194285`*^9}, {
   3.796357267967002*^9, 3.796357461567669*^9}, {3.7963575419227295`*^9, 
   3.7963575440499296`*^9}, {3.7963576044776998`*^9, 
   3.7963576333543124`*^9}, {3.796357698060563*^9, 3.7963577602000346`*^9}, {
   3.796468353399439*^9, 3.7964684238152637`*^9}, {3.7964684581603403`*^9, 
   3.7964684659507246`*^9}, {3.7964685493567886`*^9, 
   3.7964685699856834`*^9}, {3.7966287601930904`*^9, 
   3.7966287818462334`*^9}, {3.796628823729863*^9, 3.796628849678231*^9}, {
   3.796628932615207*^9, 3.796628984468155*^9}, {3.7966290626543436`*^9, 
   3.796629113159701*^9}, {3.7966291967056365`*^9, 3.7966291999675555`*^9}, {
   3.796629248748445*^9, 3.796629399183598*^9}, {3.796629536337674*^9, 
   3.796629543319502*^9}, {3.79662989818288*^9, 3.796630021623144*^9}, {
   3.796630071223344*^9, 3.796630074158272*^9}, {3.796630104846036*^9, 
   3.7966301341156745`*^9}, {3.7966301770430484`*^9, 3.796630180462965*^9}, {
   3.79663022269721*^9, 3.7966302384508204`*^9}, {3.79663027304142*^9, 
   3.79663027605363*^9}, {3.79663033694473*^9, 3.796630361833124*^9}, {
   3.7966304508759794`*^9, 3.796630488644797*^9}, {3.7966306117233033`*^9, 
   3.7966306293110113`*^9}, {3.796630669458771*^9, 3.7966308168147*^9}, {
   3.7966308795330486`*^9, 3.796630943087737*^9}, {3.796631415000393*^9, 
   3.796631422833808*^9}, {3.796631457032976*^9, 3.7966315289557505`*^9}, {
   3.79663341595769*^9, 3.796633599439583*^9}, {3.7966336684622793`*^9, 
   3.79663367604988*^9}, {3.7966337216654663`*^9, 3.796633743191372*^9}, {
   3.796633801231897*^9, 3.796633849268755*^9}, {3.796635210249427*^9, 
   3.796635398392409*^9}, {3.7966354926327868`*^9, 3.7966355134067297`*^9}, {
   3.7966357890778694`*^9, 3.7966358488653946`*^9}, {3.796636222721075*^9, 
   3.7966362229906406`*^9}, {3.796636665316095*^9, 3.796636668191804*^9}, {
   3.796636884110588*^9, 3.7966368871870565`*^9}, {3.796638059520811*^9, 
   3.7966380677649355`*^9}, {3.7966383838464785`*^9, 3.796638388943042*^9}, {
   3.7966384669949207`*^9, 3.796638479809519*^9}, {3.7966385218254824`*^9, 
   3.7966385534631357`*^9}, {3.796638665805829*^9, 3.7966387365671463`*^9}, {
   3.796639025940731*^9, 3.796639034607475*^9}, {3.79663934318991*^9, 
   3.796639375377995*^9}, {3.7966399273752623`*^9, 3.7966401428232517`*^9}, {
   3.796640204329029*^9, 3.7966402424906397`*^9}, {3.796640280532771*^9, 
   3.7966403463326855`*^9}, {3.796640480838206*^9, 3.7966407217006655`*^9}, {
   3.796640975446732*^9, 3.796640980474619*^9}, 3.796641567752325*^9, {
   3.796642057822688*^9, 3.796642059609887*^9}, {3.7966421108362865`*^9, 
   3.796642113143751*^9}, {3.7966434172968664`*^9, 3.7966434254727254`*^9}, {
   3.796643613323123*^9, 3.7966436412024527`*^9}, {3.796643679325351*^9, 
   3.796643682887101*^9}, {3.7966439922527227`*^9, 3.7966439982575736`*^9}, {
   3.7966440374150596`*^9, 3.796644040476983*^9}, {3.7966442962026033`*^9, 
   3.7966443898393016`*^9}, {3.7966444393504877`*^9, 3.796644451981138*^9}, {
   3.796645231943658*^9, 3.796645266700102*^9}, {3.7966460693148994`*^9, 
   3.796646074413436*^9}, {3.7966557538796263`*^9, 3.7966557565959187`*^9}, {
   3.796655808633333*^9, 3.796655909931201*^9}, {3.796656900337345*^9, 
   3.7966569024586377`*^9}, {3.796657228166535*^9, 3.7966572485827956`*^9}, {
   3.796657524991008*^9, 3.796657621572811*^9}, {3.7966577362910547`*^9, 
   3.796657878607893*^9}, {3.7966582503233447`*^9, 3.79665828354312*^9}, {
   3.796658447573714*^9, 3.7966584651969123`*^9}, {3.7966590485754156`*^9, 
   3.796659056869638*^9}, {3.7966591988474393`*^9, 3.796659210564679*^9}, {
   3.7966595751385427`*^9, 3.7966596429864388`*^9}, {3.796659737636689*^9, 
   3.796659772302596*^9}, {3.796659887092404*^9, 3.7966599168353405`*^9}, {
   3.7966600749355392`*^9, 3.796660090108804*^9}, {3.7966601704179554`*^9, 
   3.7966602160864916`*^9}, {3.796660272991001*^9, 3.7966602785061364`*^9}, {
   3.7966604912927384`*^9, 3.79666076436451*^9}, {3.7966607977262697`*^9, 
   3.796660812999175*^9}, {3.796660872594565*^9, 3.7966608763040223`*^9}, {
   3.796660932749575*^9, 3.7966609496091723`*^9}, {3.7966610701179085`*^9, 
   3.7966611934601693`*^9}, {3.796661252305044*^9, 3.7966613174059477`*^9}, {
   3.796661351039452*^9, 3.7966614111792955`*^9}, {3.796661442096863*^9, 
   3.796661444557089*^9}, {3.796661487325121*^9, 3.7966615003284607`*^9}, {
   3.796661537788374*^9, 3.796661537850875*^9}, {3.7966615783951616`*^9, 
   3.796661608894827*^9}, {3.7966616478793354`*^9, 3.7966616638222127`*^9}, {
   3.7966617079176884`*^9, 3.7966617625442924`*^9}, {3.7966618844117007`*^9, 
   3.796661889603151*^9}, 3.796662087240388*^9, {3.7966621572964263`*^9, 
   3.796662171477059*^9}, {3.796662238204954*^9, 3.7966623054873543`*^9}, {
   3.796662380429967*^9, 3.796662500388852*^9}, {3.7966625325582237`*^9, 
   3.7966626031693134`*^9}, {3.7966626513457346`*^9, 
   3.7966627488742943`*^9}, {3.796662829712631*^9, 3.796662851054017*^9}, 
   3.7966630856036587`*^9, 3.7966631534626207`*^9, 3.7966633752833204`*^9, {
   3.796664152908486*^9, 3.7966642324491634`*^9}, {3.7966643066759796`*^9, 
   3.7966643098846045`*^9}, {3.7966648127218904`*^9, 
   3.7966648902368555`*^9}, {3.7967039523260374`*^9, 3.796703980233099*^9}, {
   3.7967042989474077`*^9, 3.7967043039278564`*^9}, {3.796704775197977*^9, 
   3.796704783934817*^9}, 3.7967050455386524`*^9, {3.7967050937863927`*^9, 
   3.79670509907437*^9}, {3.796705271802836*^9, 3.796705273854045*^9}, {
   3.7967055814930744`*^9, 3.7967055992502747`*^9}, {3.796705678864614*^9, 
   3.7967057413922853`*^9}, {3.7967057992957573`*^9, 
   3.7967060851655416`*^9}, {3.7967061165766373`*^9, 
   3.7967063420338235`*^9}, {3.796706428037627*^9, 3.7967064338835516`*^9}, {
   3.796706779965581*^9, 3.796706785511751*^9}, {3.796707953790091*^9, 
   3.7967079582176037`*^9}, {3.796709064959115*^9, 3.7967091194907646`*^9}, {
   3.796709152741317*^9, 3.7967093010310974`*^9}, {3.7967093394458456`*^9, 
   3.796709394256879*^9}, {3.796709875534215*^9, 3.7967098804248238`*^9}, 
   3.796710442968988*^9, 3.7967110652691517`*^9, {3.7967111987336054`*^9, 
   3.796711231492309*^9}, {3.7967115729548826`*^9, 3.7967116059711637`*^9}, {
   3.796725824130427*^9, 3.796725884276824*^9}, {3.7967259150261745`*^9, 
   3.796726000797013*^9}, {3.7967260537616663`*^9, 3.7967261509190383`*^9}, {
   3.796726219912219*^9, 3.796726222787506*^9}, {3.796726275907834*^9, 
   3.7967263317722116`*^9}, {3.79672638162772*^9, 3.796726405799923*^9}, {
   3.7967264931650486`*^9, 3.79672698439279*^9}, 3.7967270560731707`*^9, {
   3.796727116830681*^9, 3.796727128445973*^9}, 3.796727181202258*^9, {
   3.7967272715383587`*^9, 3.796727302741394*^9}, 3.79672740819748*^9, {
   3.796727474604641*^9, 3.7967275103247805`*^9}, {3.7967275508301497`*^9, 
   3.7967276132198877`*^9}, {3.7967276680799646`*^9, 
   3.7967277300583963`*^9}, {3.796727837592537*^9, 3.7967278417242556`*^9}, {
   3.7967278933459773`*^9, 3.7967279533574376`*^9}, {3.7967279932260695`*^9, 
   3.796727995147734*^9}, {3.7967286173415613`*^9, 3.7967286987932878`*^9}, {
   3.7967287899851074`*^9, 3.796728821485982*^9}, {3.7967296937390256`*^9, 
   3.7967299523933973`*^9}, {3.796730002492116*^9, 3.7967300232089415`*^9}, 
   3.7967300711438785`*^9, {3.796730122518693*^9, 3.796730181561945*^9}, {
   3.796730408943618*^9, 3.796730415739225*^9}, {3.7967877086579995`*^9, 
   3.796787939070801*^9}, {3.796787979564553*^9, 3.7967880353908114`*^9}, {
   3.7967880723409433`*^9, 3.796788114440549*^9}, {3.7967881746834936`*^9, 
   3.796788226732519*^9}, {3.796788263931487*^9, 3.79678828127967*^9}, 
   3.7967883128565288`*^9, 3.7967883740780363`*^9, 3.796788434421743*^9, {
   3.7967897624838257`*^9, 3.7967897919904456`*^9}, {3.796789834218645*^9, 
   3.796789834578038*^9}, {3.796789906112769*^9, 3.796789909159631*^9}, {
   3.7978626901786723`*^9, 3.797862738821269*^9}, {3.797862782174223*^9, 
   3.7978629210109167`*^9}, {3.7978629604346886`*^9, 3.797862992113925*^9}, {
   3.797863027712222*^9, 3.7978630711804934`*^9}, {3.79786317082875*^9, 
   3.7978632029791436`*^9}, {3.7978633123165317`*^9, 3.797863353063283*^9}, {
   3.7978642899942427`*^9, 3.797864334307231*^9}, {3.7978646904715805`*^9, 
   3.797864716169705*^9}, {3.7978648028181005`*^9, 3.797864807053871*^9}, {
   3.797864857657855*^9, 3.7978648920694294`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "x", "y", 
        SuperscriptBox["x", "2"], 
        RowBox[{"x", " ", "y"}], 
        SuperscriptBox["y", "2"], 
        SuperscriptBox["x", "3"], 
        RowBox[{
         SuperscriptBox["x", "2"], " ", "y"}], 
        RowBox[{"x", " ", 
         SuperscriptBox["y", "2"]}], 
        SuperscriptBox["y", "3"], 
        RowBox[{
         SuperscriptBox["x", "3"], " ", "y"}], 
        RowBox[{"x", " ", 
         SuperscriptBox["y", "3"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["A = ", 
   MatrixForm[{{
     1, $CellContext`x, $CellContext`y, $CellContext`x^2, $CellContext`x \
$CellContext`y, $CellContext`y^2, $CellContext`x^3, $CellContext`x^2 \
$CellContext`y, $CellContext`x $CellContext`y^2, $CellContext`y^3, \
$CellContext`x^3 $CellContext`y, $CellContext`x $CellContext`y^3}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648965854673`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", "a"}], 
        RowBox[{"-", "b"}], 
        SuperscriptBox["a", "2"], 
        RowBox[{"a", " ", "b"}], 
        SuperscriptBox["b", "2"], 
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}], 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}]},
       {"0", "0", "1", "0", 
        RowBox[{"-", "a"}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", "b"}], "0", 
        SuperscriptBox["a", "2"], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "a", " ", 
         SuperscriptBox["b", "2"]}]},
       {"0", 
        RowBox[{"-", "1"}], "0", 
        RowBox[{"2", " ", "a"}], "b", "0", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a", " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "0", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", "b"}], 
        SuperscriptBox["b", "3"]},
       {"1", "a", 
        RowBox[{"-", "b"}], 
        SuperscriptBox["a", "2"], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], 
        SuperscriptBox["b", "2"], 
        SuperscriptBox["a", "3"], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "3"]}], " ", "b"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "3"]}]},
       {"0", "0", "1", "0", "a", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "b"}], "0", 
        SuperscriptBox["a", "2"], 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a", " ", "b"}], 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], 
        SuperscriptBox["a", "3"], 
        RowBox[{"3", " ", "a", " ", 
         SuperscriptBox["b", "2"]}]},
       {"0", 
        RowBox[{"-", "1"}], "0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], "b", "0", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "0", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", "b"}], 
        SuperscriptBox["b", "3"]},
       {"1", "a", "b", 
        SuperscriptBox["a", "2"], 
        RowBox[{"a", " ", "b"}], 
        SuperscriptBox["b", "2"], 
        SuperscriptBox["a", "3"], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], 
        SuperscriptBox["b", "3"], 
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b"}], 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "3"]}]},
       {"0", "0", "1", "0", "a", 
        RowBox[{"2", " ", "b"}], "0", 
        SuperscriptBox["a", "2"], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], 
        SuperscriptBox["a", "3"], 
        RowBox[{"3", " ", "a", " ", 
         SuperscriptBox["b", "2"]}]},
       {"0", 
        RowBox[{"-", "1"}], "0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a"}], 
        RowBox[{"-", "b"}], "0", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a", " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "0", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"], " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}]},
       {"1", 
        RowBox[{"-", "a"}], "b", 
        SuperscriptBox["a", "2"], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], 
        SuperscriptBox["b", "2"], 
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], 
        SuperscriptBox["b", "3"], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "3"]}], " ", "b"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "3"]}]},
       {"0", "0", "1", "0", 
        RowBox[{"-", "a"}], 
        RowBox[{"2", " ", "b"}], "0", 
        SuperscriptBox["a", "2"], 
        RowBox[{
         RowBox[{"-", "2"}], " ", "a", " ", "b"}], 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{"-", 
         SuperscriptBox["a", "3"]}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "a", " ", 
         SuperscriptBox["b", "2"]}]},
       {"0", 
        RowBox[{"-", "1"}], "0", 
        RowBox[{"2", " ", "a"}], 
        RowBox[{"-", "b"}], "0", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "0", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"], " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["C = ", 
   MatrixForm[{{
     1, -$CellContext`a, -$CellContext`b, $CellContext`a^2, $CellContext`a \
$CellContext`b, $CellContext`b^2, -$CellContext`a^3, -$CellContext`a^2 \
$CellContext`b, -$CellContext`a $CellContext`b^2, -$CellContext`b^3, \
$CellContext`a^3 $CellContext`b, $CellContext`a $CellContext`b^3}, {
     0, 0, 1, 0, -$CellContext`a, (-2) $CellContext`b, 0, $CellContext`a^2, 
      2 $CellContext`a $CellContext`b, 
      3 $CellContext`b^2, -$CellContext`a^3, (-3) $CellContext`a \
$CellContext`b^2}, {
     0, -1, 0, 2 $CellContext`a, $CellContext`b, 
      0, (-3) $CellContext`a^2, (-2) $CellContext`a $CellContext`b, \
-$CellContext`b^2, 0, 3 $CellContext`a^2 $CellContext`b, $CellContext`b^3}, {
     1, $CellContext`a, -$CellContext`b, $CellContext`a^2, -$CellContext`a \
$CellContext`b, $CellContext`b^2, $CellContext`a^3, -$CellContext`a^2 \
$CellContext`b, $CellContext`a $CellContext`b^2, -$CellContext`b^3, \
-$CellContext`a^3 $CellContext`b, -$CellContext`a $CellContext`b^3}, {
     0, 0, 1, 0, $CellContext`a, (-2) $CellContext`b, 
      0, $CellContext`a^2, (-2) $CellContext`a $CellContext`b, 
      3 $CellContext`b^2, $CellContext`a^3, 
      3 $CellContext`a $CellContext`b^2}, {
     0, -1, 0, (-2) $CellContext`a, $CellContext`b, 0, (-3) $CellContext`a^2, 
      2 $CellContext`a $CellContext`b, -$CellContext`b^2, 0, 
      3 $CellContext`a^2 $CellContext`b, $CellContext`b^3}, {
     1, $CellContext`a, $CellContext`b, $CellContext`a^2, $CellContext`a \
$CellContext`b, $CellContext`b^2, $CellContext`a^3, $CellContext`a^2 \
$CellContext`b, $CellContext`a $CellContext`b^2, $CellContext`b^3, \
$CellContext`a^3 $CellContext`b, $CellContext`a $CellContext`b^3}, {
     0, 0, 1, 0, $CellContext`a, 2 $CellContext`b, 0, $CellContext`a^2, 
      2 $CellContext`a $CellContext`b, 3 $CellContext`b^2, $CellContext`a^3, 
      3 $CellContext`a $CellContext`b^2}, {
     0, -1, 0, (-2) $CellContext`a, -$CellContext`b, 
      0, (-3) $CellContext`a^2, (-2) $CellContext`a $CellContext`b, \
-$CellContext`b^2, 
      0, (-3) $CellContext`a^2 $CellContext`b, -$CellContext`b^3}, {
     1, -$CellContext`a, $CellContext`b, $CellContext`a^2, -$CellContext`a \
$CellContext`b, $CellContext`b^2, -$CellContext`a^3, $CellContext`a^2 \
$CellContext`b, -$CellContext`a $CellContext`b^2, $CellContext`b^3, \
-$CellContext`a^3 $CellContext`b, -$CellContext`a $CellContext`b^3}, {
     0, 0, 1, 0, -$CellContext`a, 2 $CellContext`b, 
      0, $CellContext`a^2, (-2) $CellContext`a $CellContext`b, 
      3 $CellContext`b^2, -$CellContext`a^3, (-3) $CellContext`a \
$CellContext`b^2}, {
     0, -1, 0, 2 $CellContext`a, -$CellContext`b, 0, (-3) $CellContext`a^2, 
      2 $CellContext`a $CellContext`b, -$CellContext`b^2, 
      0, (-3) $CellContext`a^2 $CellContext`b, -$CellContext`b^3}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864896638854*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SuperscriptBox[\\(C\\), \\(-1\\)]\\) \
=\\!\\(\\*FractionBox[\\(\\(1\\)\\(\\\\ \\)\\), \\(8  ab\\)]\\)\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "b"}], 
        RowBox[{"2", " ", "a", " ", "b"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}]},
       {
        RowBox[{
         RowBox[{"-", "3"}], " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{"a", " ", "b"}], 
        RowBox[{"3", " ", "b"}], 
        SuperscriptBox["b", "2"], 
        RowBox[{"a", " ", "b"}], 
        RowBox[{"3", " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], 
        RowBox[{"a", " ", "b"}], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "b"}], 
        SuperscriptBox["b", "2"], 
        RowBox[{"a", " ", "b"}]},
       {
        RowBox[{
         RowBox[{"-", "3"}], " ", "a"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], 
        SuperscriptBox["a", "2"], 
        RowBox[{
         RowBox[{"-", "3"}], " ", "a"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], 
        RowBox[{"3", " ", "a"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], 
        SuperscriptBox["a", "2"], 
        RowBox[{"3", " ", "a"}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], 
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}]},
       {"0", "0", "b", "0", "0", 
        RowBox[{"-", "b"}], "0", "0", 
        RowBox[{"-", "b"}], "0", "0", "b"},
       {"4", "b", 
        RowBox[{"-", "a"}], 
        RowBox[{"-", "4"}], 
        RowBox[{"-", "b"}], 
        RowBox[{"-", "a"}], "4", 
        RowBox[{"-", "b"}], "a", 
        RowBox[{"-", "4"}], "b", "a"},
       {"0", 
        RowBox[{"-", "a"}], "0", "0", 
        RowBox[{"-", "a"}], "0", "0", "a", "0", "0", "a", "0"},
       {
        FractionBox["b", 
         SuperscriptBox["a", "2"]], "0", 
        RowBox[{"-", 
         FractionBox["b", "a"]}], 
        RowBox[{"-", 
         FractionBox["b", 
          SuperscriptBox["a", "2"]]}], "0", 
        RowBox[{"-", 
         FractionBox["b", "a"]}], 
        RowBox[{"-", 
         FractionBox["b", 
          SuperscriptBox["a", "2"]]}], "0", 
        RowBox[{"-", 
         FractionBox["b", "a"]}], 
        FractionBox["b", 
         SuperscriptBox["a", "2"]], "0", 
        RowBox[{"-", 
         FractionBox["b", "a"]}]},
       {"0", "0", 
        RowBox[{"-", "1"}], "0", "0", "1", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "1"},
       {"0", "1", "0", "0", 
        RowBox[{"-", "1"}], "0", "0", "1", "0", "0", 
        RowBox[{"-", "1"}], "0"},
       {
        FractionBox["a", 
         SuperscriptBox["b", "2"]], 
        FractionBox["a", "b"], "0", 
        FractionBox["a", 
         SuperscriptBox["b", "2"]], 
        FractionBox["a", "b"], "0", 
        RowBox[{"-", 
         FractionBox["a", 
          SuperscriptBox["b", "2"]]}], 
        FractionBox["a", "b"], "0", 
        RowBox[{"-", 
         FractionBox["a", 
          SuperscriptBox["b", "2"]]}], 
        FractionBox["a", "b"], "0"},
       {
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox["a", "2"]]}], "0", 
        FractionBox["1", "a"], 
        FractionBox["1", 
         SuperscriptBox["a", "2"]], "0", 
        FractionBox["1", "a"], 
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox["a", "2"]]}], "0", 
        RowBox[{"-", 
         FractionBox["1", "a"]}], 
        FractionBox["1", 
         SuperscriptBox["a", "2"]], "0", 
        RowBox[{"-", 
         FractionBox["1", "a"]}]},
       {
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox["b", "2"]]}], 
        RowBox[{"-", 
         FractionBox["1", "b"]}], "0", 
        FractionBox["1", 
         SuperscriptBox["b", "2"]], 
        FractionBox["1", "b"], "0", 
        RowBox[{"-", 
         FractionBox["1", 
          SuperscriptBox["b", "2"]]}], 
        FractionBox["1", "b"], "0", 
        FractionBox["1", 
         SuperscriptBox["b", "2"]], 
        RowBox[{"-", 
         FractionBox["1", "b"]}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "\!\(\*SuperscriptBox[\(C\), \(-1\)]\) =\!\(\*FractionBox[\(\(1\)\(\\ \)\), \
\(8  ab\)]\)", 
   MatrixForm[{{
     2 $CellContext`a $CellContext`b, $CellContext`a $CellContext`b^2, \
-$CellContext`a^2 $CellContext`b, 
      2 $CellContext`a $CellContext`b, $CellContext`a $CellContext`b^2, \
$CellContext`a^2 $CellContext`b, 
      2 $CellContext`a $CellContext`b, -$CellContext`a $CellContext`b^2, \
$CellContext`a^2 $CellContext`b, 
      2 $CellContext`a $CellContext`b, -$CellContext`a $CellContext`b^2, \
-$CellContext`a^2 $CellContext`b}, {(-3) $CellContext`b, -$CellContext`b^2, \
$CellContext`a $CellContext`b, 
      3 $CellContext`b, $CellContext`b^2, $CellContext`a $CellContext`b, 
      3 $CellContext`b, -$CellContext`b^2, $CellContext`a $CellContext`b, \
(-3) $CellContext`b, $CellContext`b^2, $CellContext`a $CellContext`b}, {(-3) \
$CellContext`a, -$CellContext`a $CellContext`b, $CellContext`a^2, (-3) \
$CellContext`a, -$CellContext`a $CellContext`b, -$CellContext`a^2, 
      3 $CellContext`a, -$CellContext`a $CellContext`b, $CellContext`a^2, 
      3 $CellContext`a, -$CellContext`a $CellContext`b, -$CellContext`a^2}, {
     0, 0, $CellContext`b, 0, 0, -$CellContext`b, 0, 0, -$CellContext`b, 0, 
      0, $CellContext`b}, {
     4, $CellContext`b, -$CellContext`a, -4, -$CellContext`b, -$CellContext`a,
       4, -$CellContext`b, $CellContext`a, -4, $CellContext`b, \
$CellContext`a}, {
     0, -$CellContext`a, 0, 0, -$CellContext`a, 0, 0, $CellContext`a, 0, 
      0, $CellContext`a, 0}, {$CellContext`a^(-2) $CellContext`b, 
      0, -$CellContext`a^(-1) $CellContext`b, -$CellContext`a^(-2) \
$CellContext`b, 
      0, -$CellContext`a^(-1) $CellContext`b, -$CellContext`a^(-2) \
$CellContext`b, 
      0, -$CellContext`a^(-1) $CellContext`b, $CellContext`a^(-2) \
$CellContext`b, 0, -$CellContext`a^(-1) $CellContext`b}, {0, 0, -1, 0, 0, 1, 
     0, 0, -1, 0, 0, 1}, {0, 1, 0, 0, -1, 0, 0, 1, 0, 0, -1, 
     0}, {$CellContext`a $CellContext`b^(-2), $CellContext`a/$CellContext`b, 
      0, $CellContext`a $CellContext`b^(-2), $CellContext`a/$CellContext`b, 
      0, -$CellContext`a $CellContext`b^(-2), $CellContext`a/$CellContext`b, 
      0, -$CellContext`a $CellContext`b^(-2), $CellContext`a/$CellContext`b, 
      0}, {(-1) $CellContext`a^(-2), 
      0, $CellContext`a^(-1), $CellContext`a^(-2), 
      0, $CellContext`a^(-1), (-1) $CellContext`a^(-2), 
      0, (-1)/$CellContext`a, $CellContext`a^(-2), 
      0, (-1)/$CellContext`a}, {(-1) $CellContext`b^(-2), (-1)/$CellContext`b,
       0, $CellContext`b^(-2), $CellContext`b^(-1), 
      0, (-1) $CellContext`b^(-2), $CellContext`b^(-1), 
      0, $CellContext`b^(-2), (-1)/$CellContext`b, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864896654479*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N = \\!\\(\\*FractionBox[\\(1\\), \\(8\\)]\\)\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             SuperscriptBox["b", "2"], " ", "x"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"]}], "+", 
               RowBox[{"b", " ", "y"}], "+", 
               SuperscriptBox["y", "2"]}], ")"}]}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "x"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             SuperscriptBox["b", "2"], " ", "x"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"b", "-", "y"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "b"}], "+", "y"}], ")"}]}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "b"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", " ", 
             SuperscriptBox["b", "2"], " ", "x"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "b"}], "-", "y"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"b", "+", "y"}], ")"}]}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "y"}], ")"}], "2"]}], 
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"]}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "b"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"a", "-", "x"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "a"}], "+", "x"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "b", " ", "y"}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["y", "2"]}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "y"}], ")"}], "2"]}], 
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"a", "-", "x"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["N = \!\(\*FractionBox[\(1\), \(8\)]\)", 
   MatrixForm[{{$CellContext`a^(-3) $CellContext`b^(-3) (-$CellContext`a + \
$CellContext`x) ($CellContext`b - $CellContext`y) ($CellContext`a \
$CellContext`b^2 $CellContext`x + $CellContext`b^2 $CellContext`x^2 + \
$CellContext`a^2 ((-2) $CellContext`b^2 + $CellContext`b $CellContext`y + \
$CellContext`y^2)), $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`a - \
$CellContext`x) ($CellContext`b - $CellContext`y)^2 ($CellContext`b + \
$CellContext`y), -$CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - \
$CellContext`x)^2 ($CellContext`a + $CellContext`x) ($CellContext`b - \
$CellContext`y), $CellContext`a^(-3) $CellContext`b^(-3) ($CellContext`a + \
$CellContext`x) ($CellContext`b - $CellContext`y) ($CellContext`a \
$CellContext`b^2 $CellContext`x - $CellContext`b^2 $CellContext`x^2 + \
$CellContext`a^2 ($CellContext`b - $CellContext`y) (
         2 $CellContext`b + $CellContext`y)), $CellContext`a^(-1) \
$CellContext`b^(-2) ($CellContext`a + $CellContext`x) ($CellContext`b - \
$CellContext`y)^2 ($CellContext`b + $CellContext`y), $CellContext`a^(-2) \
$CellContext`b^(-1) ($CellContext`a - $CellContext`x) ($CellContext`a + \
$CellContext`x)^2 ($CellContext`b - $CellContext`y), $CellContext`a^(-3) \
$CellContext`b^(-3) ($CellContext`a + $CellContext`x) ($CellContext`b + \
$CellContext`y) ($CellContext`a $CellContext`b^2 $CellContext`x - \
$CellContext`b^2 $CellContext`x^2 + $CellContext`a^2 (
         2 $CellContext`b - $CellContext`y) ($CellContext`b + \
$CellContext`y)), -$CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`a + \
$CellContext`x) ($CellContext`b - $CellContext`y) ($CellContext`b + \
$CellContext`y)^2, $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - \
$CellContext`x) ($CellContext`a + $CellContext`x)^2 ($CellContext`b + \
$CellContext`y), $CellContext`a^(-3) $CellContext`b^(-3) ($CellContext`a - \
$CellContext`x) ($CellContext`b + $CellContext`y) ($CellContext`b^2 \
($CellContext`a - $CellContext`x) (
         2 $CellContext`a + $CellContext`x) + $CellContext`a^2 $CellContext`b \
$CellContext`y - $CellContext`a^2 $CellContext`y^2), -$CellContext`a^(-1) \
$CellContext`b^(-2) ($CellContext`a - $CellContext`x) ($CellContext`b - \
$CellContext`y) ($CellContext`b + $CellContext`y)^2, -$CellContext`a^(-2) \
$CellContext`b^(-1) ($CellContext`a - $CellContext`x)^2 ($CellContext`a + \
$CellContext`x) ($CellContext`b + $CellContext`y)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864896970888*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"B = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"3", " ", "x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "b"}], "+", "y"}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", "b"}]], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", 
             RowBox[{"3", " ", "x"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", "b"}]]}], 
        FractionBox[
         RowBox[{"3", " ", "x", " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", "b"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"3", " ", "x"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "b"}]], 
        FractionBox[
         RowBox[{"3", " ", "x", " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", "b"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"3", " ", "x"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "b"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"3", " ", "x", " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "3"], " ", "b"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", 
             RowBox[{"3", " ", "x"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", "b"}]]}]},
       {
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "+", "x"}], ")"}], " ", "y"}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "3"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", 
            RowBox[{"3", " ", "y"}]}], ")"}]}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "2"]}]], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", "y"}], 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["b", "3"]}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", 
            RowBox[{"3", " ", "y"}]}], ")"}]}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "2"]}]], "0", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", "y"}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"3", " ", "y"}]}], ")"}]}], 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["b", "2"]}]]}], "0", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", "y"}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"3", " ", "y"}]}], ")"}]}], 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["b", "2"]}]]}], "0"},
       {
        FractionBox[
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"3", " ", "y"}]}], ")"}]}], 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["b", "2"]}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"3", " ", "x"}]}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "b"}]], 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"3", " ", "y"}]}], ")"}]}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "2"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", 
            RowBox[{"3", " ", "x"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "b"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", 
            RowBox[{"3", " ", "y"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"4", " ", "a", " ", 
          SuperscriptBox["b", "2"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", 
             RowBox[{"3", " ", "x"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", "b"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "3"], " ", 
          SuperscriptBox["b", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", 
             RowBox[{"3", " ", "y"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["b", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"3", " ", "x"}]}], ")"}]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", "b"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["B = ", 
   MatrixForm[{{
     Rational[3, 
        4] $CellContext`a^(-3) $CellContext`b^(-1) $CellContext`x \
(-$CellContext`b + $CellContext`y), 0, 
      Rational[-1, 4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - 
       3 $CellContext`x) ($CellContext`b - $CellContext`y), 
      Rational[3, 
        4] $CellContext`a^(-3) $CellContext`b^(-1) $CellContext`x \
($CellContext`b - $CellContext`y), 0, 
      Rational[1, 4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a + 
       3 $CellContext`x) ($CellContext`b - $CellContext`y), 
      Rational[3, 
        4] $CellContext`a^(-3) $CellContext`b^(-1) $CellContext`x \
($CellContext`b + $CellContext`y), 0, 
      Rational[1, 4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a + 
       3 $CellContext`x) ($CellContext`b + $CellContext`y), 
      Rational[-3, 
        4] $CellContext`a^(-3) $CellContext`b^(-1) $CellContext`x \
($CellContext`b + $CellContext`y), 0, 
      Rational[-1, 4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - 
       3 $CellContext`x) ($CellContext`b + $CellContext`y)}, {
     Rational[3, 
        4] $CellContext`a^(-1) $CellContext`b^(-3) (-$CellContext`a + \
$CellContext`x) $CellContext`y, 
      Rational[1, 
        4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`a - \
$CellContext`x) ($CellContext`b - 3 $CellContext`y), 0, 
      Rational[-3, 
        4] $CellContext`a^(-1) $CellContext`b^(-3) ($CellContext`a + \
$CellContext`x) $CellContext`y, 
      Rational[1, 
        4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`a + \
$CellContext`x) ($CellContext`b - 3 $CellContext`y), 0, 
      Rational[3, 
        4] $CellContext`a^(-1) $CellContext`b^(-3) ($CellContext`a + \
$CellContext`x) $CellContext`y, 
      Rational[-1, 
        4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`a + \
$CellContext`x) ($CellContext`b + 3 $CellContext`y), 0, 
      Rational[3, 
        4] $CellContext`a^(-1) $CellContext`b^(-3) ($CellContext`a - \
$CellContext`x) $CellContext`y, 
      Rational[-1, 
        4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`a - \
$CellContext`x) ($CellContext`b + 3 $CellContext`y), 0}, {
     Rational[1, 4] $CellContext`a^(-3) $CellContext`b^(-3) (
       3 $CellContext`b^2 $CellContext`x^2 + $CellContext`a^2 ((-4) \
$CellContext`b^2 + 3 $CellContext`y^2)), 
      Rational[-1, 
        4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`b - \
$CellContext`y) ($CellContext`b + 3 $CellContext`y), 
      Rational[1, 
        4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - \
$CellContext`x) ($CellContext`a + 3 $CellContext`x), 
      Rational[1, 
        4] $CellContext`a^(-3) $CellContext`b^(-3) ((-3) $CellContext`b^2 \
$CellContext`x^2 + $CellContext`a^2 (4 $CellContext`b^2 - 
         3 $CellContext`y^2)), 
      Rational[1, 
        4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`b - \
$CellContext`y) ($CellContext`b + 3 $CellContext`y), 
      Rational[1, 4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - 
       3 $CellContext`x) ($CellContext`a + $CellContext`x), 
      Rational[1, 4] $CellContext`a^(-3) $CellContext`b^(-3) (
       3 $CellContext`b^2 $CellContext`x^2 + $CellContext`a^2 ((-4) \
$CellContext`b^2 + 3 $CellContext`y^2)), 
      Rational[1, 4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`b - 
       3 $CellContext`y) ($CellContext`b + $CellContext`y), 
      Rational[-1, 4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - 
       3 $CellContext`x) ($CellContext`a + $CellContext`x), 
      Rational[
       1, 4] $CellContext`a^(-3) $CellContext`b^(-3) ((-3) $CellContext`b^2 \
$CellContext`x^2 + $CellContext`a^2 (4 $CellContext`b^2 - 
         3 $CellContext`y^2)), 
      Rational[-1, 4] $CellContext`a^(-1) $CellContext`b^(-2) ($CellContext`b - 
       3 $CellContext`y) ($CellContext`b + $CellContext`y), 
      Rational[-1, 
        4] $CellContext`a^(-2) $CellContext`b^(-1) ($CellContext`a - \
$CellContext`x) ($CellContext`a + 3 $CellContext`x)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972091637`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"D = \\!\\(\\*FractionBox[\\(Em*\\*SuperscriptBox[\\(h\\), \\(3\
\\)]\\), \\(12*\\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "\[Nu]", "0"},
       {"\[Nu]", "1", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"1", "-", "\[Nu]"}], "2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "D = \!\(\*FractionBox[\(Em*\*SuperscriptBox[\(h\), \(3\)]\), \(12*\((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)", 
   MatrixForm[{{1, $CellContext`\[Nu], 0}, {$CellContext`\[Nu], 1, 0}, {
     0, 0, Rational[1, 2] (1 - $CellContext`\[Nu])}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972091637`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "x", "y", 
        SuperscriptBox["x", "2"], 
        RowBox[{"x", " ", "y"}], 
        SuperscriptBox["y", "2"], 
        SuperscriptBox["x", "3"], 
        RowBox[{
         SuperscriptBox["x", "2"], " ", "y"}], 
        RowBox[{"x", " ", 
         SuperscriptBox["y", "2"]}], 
        SuperscriptBox["y", "3"], 
        RowBox[{
         SuperscriptBox["x", "3"], " ", "y"}], 
        RowBox[{"x", " ", 
         SuperscriptBox["y", "3"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["A = ", 
   MatrixForm[{{
     1, $CellContext`x, $CellContext`y, $CellContext`x^2, $CellContext`x \
$CellContext`y, $CellContext`y^2, $CellContext`x^3, $CellContext`x^2 \
$CellContext`y, $CellContext`x $CellContext`y^2, $CellContext`y^3, \
$CellContext`x^3 $CellContext`y, $CellContext`x $CellContext`y^3}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972247934`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AzaRIvrsta = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", 
        RowBox[{"-", "2"}], "0", "0", 
        RowBox[{
         RowBox[{"-", "6"}], " ", "x"}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", "y"}], "0", "0", 
        RowBox[{
         RowBox[{"-", "6"}], " ", "x", " ", "y"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["AzaRIvrsta = ", 
   MatrixForm[{{
     0, 0, 0, -2, 0, 0, (-6) $CellContext`x, (-2) $CellContext`y, 0, 
      0, (-6) $CellContext`x $CellContext`y, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972247934`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AzaRIIvrsta = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0", "0", 
        RowBox[{"-", "2"}], "0", "0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "x"}], 
        RowBox[{
         RowBox[{"-", "6"}], " ", "y"}], "0", 
        RowBox[{
         RowBox[{"-", "6"}], " ", "x", " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["AzaRIIvrsta = ", 
   MatrixForm[{{
     0, 0, 0, 0, 0, -2, 0, 0, (-2) $CellContext`x, (-6) $CellContext`y, 
      0, (-6) $CellContext`x $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972247934`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"AzaRIIIvrsta = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0", 
        RowBox[{"-", "2"}], "0", "0", 
        RowBox[{
         RowBox[{"-", "4"}], " ", "x"}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "y"}], "0", 
        RowBox[{
         RowBox[{"-", "6"}], " ", 
         SuperscriptBox["x", "2"]}], 
        RowBox[{
         RowBox[{"-", "6"}], " ", 
         SuperscriptBox["y", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["AzaRIIIvrsta = ", 
   MatrixForm[{{
     0, 0, 0, 0, -2, 0, 0, (-4) $CellContext`x, (-4) $CellContext`y, 
      0, (-6) $CellContext`x^2, (-6) $CellContext`y^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972247934`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R = -\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "2", "0", "0", 
        RowBox[{"6", " ", "x"}], 
        RowBox[{"2", " ", "y"}], "0", "0", 
        RowBox[{"6", " ", "x", " ", "y"}], "0"},
       {"0", "0", "0", "0", "0", "2", "0", "0", 
        RowBox[{"2", " ", "x"}], 
        RowBox[{"6", " ", "y"}], "0", 
        RowBox[{"6", " ", "x", " ", "y"}]},
       {"0", "0", "0", "0", "2", "0", "0", 
        RowBox[{"4", " ", "x"}], 
        RowBox[{"4", " ", "y"}], "0", 
        RowBox[{"6", " ", 
         SuperscriptBox["x", "2"]}], 
        RowBox[{"6", " ", 
         SuperscriptBox["y", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["R = -", 
   MatrixForm[{{
     0, 0, 0, 2, 0, 0, 6 $CellContext`x, 2 $CellContext`y, 0, 0, 
      6 $CellContext`x $CellContext`y, 0}, {
     0, 0, 0, 0, 0, 2, 0, 0, 2 $CellContext`x, 6 $CellContext`y, 0, 
      6 $CellContext`x $CellContext`y}, {
     0, 0, 0, 0, 2, 0, 0, 4 $CellContext`x, 4 $CellContext`y, 0, 
      6 $CellContext`x^2, 6 $CellContext`y^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978648972247934`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 1, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649108094316`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649108094316`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 1, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864917000389*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649170160127`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 1, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864923486104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864923486104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 1, "-", 
   4, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649316735554`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786493168918*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 1, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649377520285`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649377676525`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 1, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649455034027`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649455034027`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 1, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864952708028*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864952708028*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 1, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864958834169*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864958834169*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 1, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864964741826*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864964741826*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 1, "-", 
   10, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864973322407*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864973322407*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 1, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864980385065*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864980385065*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "1", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 1, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 1, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864986853777*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864986869402*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 2, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864994222151*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797864994222151*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 2, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649970763206`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978649970919447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 2, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650004380875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650004380875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 2, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650077600994`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650077600994`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 2, 
   "-", 5, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650116050873`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650116050873`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 2, "-",
    6, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786501588631*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650159019365`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 2, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650231214504`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650231214504`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 2, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650252776885`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865025293317*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 2, "-",
    9, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650311214037`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650311214037`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_", 
   "", 2, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786503976453*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865039780156*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 2, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650422645173`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650422645173`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "2", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 2, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 2, "-",
    12, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650469062457`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650469062457`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 3, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650544231825`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650544231825`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 3, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865057737369*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865057737369*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 3, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650616128054`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650616128054`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 3, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865069098745*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650691143675`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 3, "-",
    5, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865073428449*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865073428449*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 3, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650758971844`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650758971844`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 3, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786508274222*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786508274222*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 3, "-",
    8, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865088728178*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865088728178*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 3, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865091041814*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865091057439*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 3, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650984096622`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978650984096622`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 3, "-",
    11, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651027896795`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651027896795`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "3", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 3, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 3, 
   "-", 12, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \
\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651068443604`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651068443604`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 4, "-", 
   1, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865116941925*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865116941925*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 4, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865123632539*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865123632539*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 4, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651315078363`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651315234613`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 4, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651401509547`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651401665792`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 4, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651486833086`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651486833086`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]; kSekulovic_",
    "", 4, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651567312956`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651567312956`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 4, "-", 
   7, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786516563801*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786516563801*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 4, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651734063487`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651734219747`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 4, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865180703657*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865180703657*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 4, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651892218*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865189237425*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 4, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651958813334`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978651958813334`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "4", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 4, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 4, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652041820316`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652041820316`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 5, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865212152032*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865212167656*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 5, 
   "-", 2, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652162617407`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652162617407`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 5, "-",
    3, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652211835856`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652211835856`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 5, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865229670715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865229670715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 5, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652327190123`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652327346363`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 
   5, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652361880927`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652362037153`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_", 
   "", 5, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652449393845`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652449393845`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 5, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652474408455`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786524745647*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 5, "-",
    9, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652516603527`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652516603527`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 5, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652593649054`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652593649054`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 5, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865261630519*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652616461425`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "5", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 5, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 5, "-",
    12, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865267117282*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865267132908*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 6, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652762602253`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652762602253`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 6, "-",
    2, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652807771344`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652807771344`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 6, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652832941704`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652832941704`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]; kSekulovic_",
    "", 6, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865292498499*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978652925141225`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 
   6, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865296140246*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865296155871*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 6, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653000740347`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653000740347`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 6, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653088924303`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653088924303`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 6, "-",
    8, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653132361546`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653132517796`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 6, 
   "-", 9, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653171441503`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653171441503`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 6, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865324035109*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865324035109*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 6, "-",
    11, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653293645296`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653293645296`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "6", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 6, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 6, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653315676427`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653315832667`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 7, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865340600322*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865340615947*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 7, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653476030197`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653476030197`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 7, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865356074082*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865356074082*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 7, "-", 
   4, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865367185932*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865367185932*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_", 
   "", 7, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653759205904`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653759205904`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 7, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653842824683`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978653842824683`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 7, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786539344611*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786539344611*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 7, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654007981353`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654007981353`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]; kSekulovic_",
    "", 7, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865409199459*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865409199459*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 7, "-", 
   10, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654189818068`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654189974303`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]; kSekulovic_", "", 7, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865426045648*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865426045648*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "7", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 7, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 7, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865434015771*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865434015771*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 8, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654418764534`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654418920774`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 8, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654441113696`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654441113696`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 8, "-",
    3, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654503457065`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654503613324`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 8, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786545852213*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865458537753*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 8, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865461022114*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865461022114*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 8, "-",
    6, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654652421465`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654652577696`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 8, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654736341176`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654736497416`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 8, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865476618475*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865476618475*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 8, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865480227827*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865480227827*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]; kSekulovic_", "", 8, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978654881822357`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786548819786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 8, 
   "-", 11, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \
\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865492542968*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865492542968*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "8", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 8, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 8, "-",
    12, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865497222599*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865497238226*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 9, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655051793823`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655051793823`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 9, "-",
    2, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865511148097*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865511148097*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 9, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655133992376`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655133992376`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 9, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865520899623*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865520899623*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 9, "-",
    5, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865525135385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865525135385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 9, 
   "-", 6, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865529278677*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865529278677*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]; kSekulovic_",
    "", 9, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865538060255*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865538060255*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 9, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a \
$CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655415614576`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655415614576`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 9, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865545389559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865545389559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 9, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655542189517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655542189517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 9, "-",
    11, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655587983956`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655588140206`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "9", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 9, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 9, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865561440394*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865561440394*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], 
      SuperscriptBox["b", "2"]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 10, "-", 
   1, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^2 \
$CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865571236806*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865571236806*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_", 
   "", 10, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865579381464*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865579381464*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 10, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655871965094`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978655872121334`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"7", "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"]}]], "-", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 10, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] (7 - 
    5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865597748578*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865597748578*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "b"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 10, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865604963437*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865604963437*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
     RowBox[{"5", " ", "a"}]]}], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 10, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[-2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656128814473`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656128814473`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], 
     SuperscriptBox["a", "2"]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]; kSekulovic_", "", 10, "-", 
   7, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   2 $CellContext`a^2 $CellContext`b^(-2) - 
   4 $CellContext`a^(-2) $CellContext`b^2 + 
   Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656231186132`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656231186132`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]; kSekulovic_", "", 10, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786563074603*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865630761654*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 10, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656397619796`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656397619796`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 10, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865649418537*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656494341617`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 10, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865657576071*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865657576071*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "10", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 10, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 10, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865666343042*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656663586655`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}], "b"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 11, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865675392672*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656754082947`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 11, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865677829235*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865677844861*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 11, 
   "-", 3, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865682488747*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865682488747*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "b"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 11, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`b^(-1) (
    5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865690615135*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.79786569063076*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 11, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656928350253`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978656928350253`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 11, 
   "-", 6, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865698668559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865698668559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
      RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]; kSekulovic_", "", 11, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
    4 $CellContext`b $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657068792715`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657068948956`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 11, 
   "-", 8, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`a^2 + 
    2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657110918517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657111074753`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 11, 
   "-", 9, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657159213448`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657159369693`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}], "b"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 11, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) \
$CellContext`a^2/$CellContext`b + 
   Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865726412882*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865726428506*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 11, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865729553488*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657295691123`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "11", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 11, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 
   11, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657336017075`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657336017075`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "+", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 12, "-", 1, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-2) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657420103416`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657420103416`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 2, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 12, 
   "-", 2, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865746369689*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865746369689*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 3, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]; kSekulovic_", "", 12, 
   "-", 3, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[8, 15] (5 $CellContext`b^2 + 
    2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865750324283*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657503399096`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
    RowBox[{"5", " ", "a"}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 12, "-", 4, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[2, 5] $CellContext`a^(-1) (
    5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657580922914`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657580922914`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 5, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 12, 
   "-", 5, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657635624247`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657635624247`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 12, "-", 6, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657657811627`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657657811627`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}], "a"], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]; kSekulovic_",
    "", 12, "-", 7, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a^(-1) $CellContext`b^2 + 
   Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865774470545*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865774470545*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 8, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]; kSekulovic_", "", 12, 
   "-", 8, " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 \
- \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 0, "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657790968876`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657790968876`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 12, "-", 9, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[4, 15] (
    10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657817217326`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657817217326`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"]}], "a"]}], "-", 
    RowBox[{
     FractionBox["2", "5"], " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]; kSekulovic_", "", 12, "-", 10, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
   "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978657918807836`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865791896409*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]; kSekulovic_", "", 
   12, "-", 11, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   4 $CellContext`a $CellContext`b $CellContext`\[Nu], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865795831216*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865795846841*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k_\"\>", "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", 
   "12", "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]; kSekulovic_\"\>", 
   "\[InvisibleSpace]", "\<\"\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)[\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["16", "15"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "k_", "", 12, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
   "]; kSekulovic_", "", 12, "-", 12, 
   " = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \((1 - \
\*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)[", 
   Rational[16, 15] (
    5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), "]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865800104206*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Kontrola: k - kSekulovic = \"\>", "\[InvisibleSpace]", 
   TagBox["0",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Kontrola: k - kSekulovic = ", 
   MatrixForm[0]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865800104206*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"kSekulovic = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0"},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0"},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}]},
       {
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0"},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "kSekulovic = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \
\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)", 
   MatrixForm[{{
     4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 
        4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 
        4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
      Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a^2 $CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 
         5] $CellContext`b (-1 + $CellContext`\[Nu]), (-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu])}, {
     4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a $CellContext`b $CellContext`\[Nu], 
      2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0, (-4) $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0}, {(-4) $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 
        4 $CellContext`\[Nu]), (-4) $CellContext`a $CellContext`b \
$CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, {
     2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
      4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 
        4 $CellContext`\[Nu]), (-4) $CellContext`a^2 $CellContext`b^(-2) + 
      2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, {
     2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu], (-4) \
$CellContext`a^2/$CellContext`b + 
      Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0}, {(-4) $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, {
     Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a^2 $CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + 
      Rational[2, 5] (7 - 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu])}, {
     Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0, (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a $CellContext`b $CellContext`\[Nu], 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0}, {
     Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 
        4 $CellContext`\[Nu]), (-4) $CellContext`a $CellContext`b \
$CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, \
{(-4) $CellContext`a^2 $CellContext`b^(-2) + 
      2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[2, 
         5] $CellContext`b (-1 + $CellContext`\[Nu]), (-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
      4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + 
      Rational[2, 5] (7 - 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 
        4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu])}, {
     4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0, (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu]}, {(-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), \
(-4) $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu]))}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978658029110985`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"         k = \\!\\(\\*FractionBox[SuperscriptBox[\\(Eh\\), \
\\(3\\)], \\(48  ab \\((1 - \\*SuperscriptBox[\\(\[Nu]\\), \
\\(2\\)])\\)\\)]\\)\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0"},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0"},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}]},
       {
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0"},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "4"}], " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], 
           SuperscriptBox["b", "2"]]}], "+", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"7", "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "4"], "+", 
               SuperscriptBox["b", "4"]}], ")"}]}], 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"]}]], "-", 
           RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "b"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
          RowBox[{"5", " ", "a"}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"]}], 
          SuperscriptBox["b", "2"]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["a", "2"]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "7"}], "+", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "4"], "+", 
             SuperscriptBox["b", "4"]}], ")"}]}], 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}]], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"]}], "b"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["a", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "b"}]], 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox["2", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["a", "2"]}], "b"]}], "+", "b", "+", 
           RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}], 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "2"]}], "b"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"4", " ", "b", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["a", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "+", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["8", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["b", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
         RowBox[{"5", " ", "a"}]], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], "a"], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], "0", 
        RowBox[{
         FractionBox["4", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "a"]}], "-", 
         RowBox[{
          FractionBox["2", "5"], " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "\[Nu]"}]}], ")"}]}]}], 
        RowBox[{"4", " ", "a", " ", "b", " ", "\[Nu]"}], 
        RowBox[{
         FractionBox["16", "15"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "         k = \!\(\*FractionBox[SuperscriptBox[\(Eh\), \(3\)], \(48  ab \
\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)", 
   MatrixForm[{{
     4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 
        4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 
        4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
      Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a^2 $CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 
         5] $CellContext`b (-1 + $CellContext`\[Nu]), (-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu])}, {
     4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a $CellContext`b $CellContext`\[Nu], 
      2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0, (-4) $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0}, {(-4) $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 
        4 $CellContext`\[Nu]), (-4) $CellContext`a $CellContext`b \
$CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, {
     2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
      4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + Rational[2, 5] (7 - 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 
        4 $CellContext`\[Nu]), (-4) $CellContext`a^2 $CellContext`b^(-2) + 
      2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, {
     2 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu], (-4) \
$CellContext`a^2/$CellContext`b + 
      Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0}, {(-4) $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, {
     Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a^2 $CellContext`b^(-2) + 2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + 
      Rational[2, 5] (7 - 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu])}, {
     Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0, (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a $CellContext`b $CellContext`\[Nu], 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0}, {
     Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      2 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 
        4 $CellContext`\[Nu]), (-4) $CellContext`a $CellContext`b \
$CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), (-4) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu]))}, \
{(-4) $CellContext`a^2 $CellContext`b^(-2) + 
      2 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[2, 
         5] $CellContext`b (-1 + $CellContext`\[Nu]), (-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      Rational[2, 5] (7 - 
       5 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) - 2 $CellContext`\[Nu]), 
      Rational[-2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[-2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      2 $CellContext`a^2 $CellContext`b^(-2) - 
      4 $CellContext`a^(-2) $CellContext`b^2 + 
      Rational[2, 5] (-7 + 2 $CellContext`\[Nu]), 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + Rational[2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 
      4 $CellContext`a^(-2) $CellContext`b^(-2) ($CellContext`a^4 + \
$CellContext`b^4) + 
      Rational[2, 5] (7 - 
        2 $CellContext`\[Nu]), (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 
        4 $CellContext`b $CellContext`\[Nu]), (-4) $CellContext`a^(-1) \
$CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu])}, {
     4 $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] $CellContext`b (-1 + $CellContext`\[Nu]), 
      Rational[4, 15] (
       10 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[2, 5] $CellContext`b^(-1) (
       5 $CellContext`a^2 + $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      Rational[4, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[2, 5] ((-5) $CellContext`a^2/$CellContext`b + $CellContext`b + 
       4 $CellContext`b $CellContext`\[Nu]), 
      Rational[8, 15] (5 $CellContext`a^2 + 
       2 $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      0, (-4) $CellContext`a^2/$CellContext`b + 
      Rational[-2, 5] ($CellContext`b + 4 $CellContext`b $CellContext`\[Nu]), 
      Rational[16, 15] (
       5 $CellContext`a^2 - $CellContext`b^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu]}, {(-2) \
$CellContext`a^(-1) $CellContext`b^2 + 
      Rational[2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 0, 
      Rational[8, 15] (5 $CellContext`b^2 + 
       2 $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      Rational[2, 5] $CellContext`a^(-1) (
       5 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), 0, 
      Rational[4, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu])), 
      4 $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (-1 + $CellContext`\[Nu]), 0, 
      Rational[4, 15] (
       10 $CellContext`b^2 + $CellContext`a^2 (-1 + $CellContext`\[Nu])), \
(-4) $CellContext`a^(-1) $CellContext`b^2 + 
      Rational[-2, 5] $CellContext`a (1 + 4 $CellContext`\[Nu]), 
      4 $CellContext`a $CellContext`b $CellContext`\[Nu], 
      Rational[16, 15] (
       5 $CellContext`b^2 - $CellContext`a^2 (-1 + $CellContext`\[Nu]))}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978658051779895`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"kSekulovic - k = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["kSekulovic - k = ", 
   MatrixForm[{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.797865805412363*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Q = q\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"a", " ", "b"}]},
       {
        FractionBox[
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}], "3"]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b"}], "3"]}]},
       {
        RowBox[{"a", " ", "b"}]},
       {
        FractionBox[
         RowBox[{"a", " ", 
          SuperscriptBox["b", "2"]}], "3"]},
       {
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], " ", "b"}], "3"]},
       {
        RowBox[{"a", " ", "b"}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"]}], "3"]}]},
       {
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], " ", "b"}], "3"]},
       {
        RowBox[{"a", " ", "b"}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"]}], "3"]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b"}], "3"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Q = q", 
   MatrixForm[{{$CellContext`a $CellContext`b}, {
     Rational[1, 3] $CellContext`a $CellContext`b^2}, {
     Rational[-1, 
        3] $CellContext`a^2 $CellContext`b}, {$CellContext`a $CellContext`b}, \
{Rational[1, 3] $CellContext`a $CellContext`b^2}, {
     Rational[1, 
        3] $CellContext`a^2 $CellContext`b}, {$CellContext`a $CellContext`b}, \
{Rational[-1, 3] $CellContext`a $CellContext`b^2}, {
     Rational[1, 
        3] $CellContext`a^2 $CellContext`b}, {$CellContext`a $CellContext`b}, \
{Rational[-1, 3] $CellContext`a $CellContext`b^2}, {
     Rational[-1, 3] $CellContext`a^2 $CellContext`b}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796726434658085*^9, {3.796727042807003*^9, 3.7967270605278163`*^9}, 
   3.796727140343738*^9, 3.7967271854641447`*^9, 3.796727325277816*^9, 
   3.7967274192400827`*^9, 3.7967274821967335`*^9, 3.79672751416096*^9, 
   3.7967275759557548`*^9, 3.796727617388919*^9, {3.7967276726887817`*^9, 
   3.796727692171795*^9}, 3.7967277610814843`*^9, 3.796727807484898*^9, 
   3.7967278448235264`*^9, 3.7967278991902895`*^9, {3.796727931901377*^9, 
   3.796727958099145*^9}, 3.7967280050287633`*^9, 3.7967286646895494`*^9, 
   3.79672870434612*^9, 3.7967288267851963`*^9, 3.7967299644500647`*^9, 
   3.7967300281500454`*^9, 3.796730076164589*^9, 3.7967301869871616`*^9, 
   3.7967304204643264`*^9, 3.7967879440099277`*^9, 3.796788321264389*^9, 
   3.7967883976931963`*^9, 3.796788442877982*^9, 3.7978630888451624`*^9, 
   3.797863207680691*^9, 3.7978633644386454`*^9, 3.797864107014871*^9, {
   3.797864784369403*^9, 3.797864810756973*^9}, 3.7978658135252943`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1920, 997},
WindowMargins->{{1912, Automatic}, {Automatic, -8}},
Magnification:>1.2 Inherited,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 7, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 89503, 1844, 3386, "Input"],
Cell[CellGroupData[{
Cell[90107, 1870, 2431, 52, 26, "Print"],
Cell[92541, 1924, 10163, 256, 257, "Print"],
Cell[102707, 2182, 9138, 230, 280, "Print"],
Cell[111848, 2414, 10458, 256, 45, "Print"],
Cell[122309, 2672, 14786, 387, 105, "Print"],
Cell[137098, 3061, 2192, 44, 74, "Print"],
Cell[139293, 3107, 2431, 52, 26, "Print"],
Cell[141727, 3161, 2093, 44, 26, "Print"],
Cell[143823, 3207, 2095, 44, 26, "Print"],
Cell[145921, 3253, 2210, 48, 26, "Print"],
Cell[148134, 3303, 2607, 55, 62, "Print"],
Cell[150744, 3360, 3189, 69, 50, "Print"],
Cell[153936, 3431, 1251, 22, 26, "Print"],
Cell[155190, 3455, 2837, 57, 50, "Print"],
Cell[158030, 3514, 1251, 22, 26, "Print"],
Cell[159284, 3538, 2867, 58, 50, "Print"],
Cell[162154, 3598, 1249, 22, 26, "Print"],
Cell[163406, 3622, 3189, 70, 50, "Print"],
Cell[166598, 3694, 1248, 22, 26, "Print"],
Cell[167849, 3718, 2845, 58, 50, "Print"],
Cell[170697, 3778, 1251, 22, 26, "Print"],
Cell[171951, 3802, 2855, 58, 50, "Print"],
Cell[174809, 3862, 1251, 22, 26, "Print"],
Cell[176063, 3886, 3191, 68, 50, "Print"],
Cell[179257, 3956, 1249, 22, 26, "Print"],
Cell[180509, 3980, 2991, 61, 50, "Print"],
Cell[183503, 4043, 1249, 22, 26, "Print"],
Cell[184755, 4067, 3059, 64, 50, "Print"],
Cell[187817, 4133, 1249, 22, 26, "Print"],
Cell[189069, 4157, 3233, 70, 50, "Print"],
Cell[192305, 4229, 1249, 22, 26, "Print"],
Cell[193557, 4253, 2805, 57, 50, "Print"],
Cell[196365, 4312, 1249, 22, 26, "Print"],
Cell[197617, 4336, 2869, 58, 50, "Print"],
Cell[200489, 4396, 1249, 22, 26, "Print"],
Cell[201741, 4420, 2837, 57, 50, "Print"],
Cell[204581, 4479, 1249, 22, 26, "Print"],
Cell[205833, 4503, 2901, 61, 50, "Print"],
Cell[208737, 4566, 1251, 22, 26, "Print"],
Cell[209991, 4590, 2365, 40, 50, "Print"],
Cell[212359, 4632, 1251, 22, 26, "Print"],
Cell[213613, 4656, 2845, 58, 50, "Print"],
Cell[216461, 4716, 1251, 22, 26, "Print"],
Cell[217715, 4740, 2917, 60, 50, "Print"],
Cell[220635, 4802, 1251, 22, 26, "Print"],
Cell[221889, 4826, 2118, 34, 50, "Print"],
Cell[224010, 4862, 1251, 22, 26, "Print"],
Cell[225264, 4886, 3061, 64, 50, "Print"],
Cell[228328, 4952, 1251, 22, 26, "Print"],
Cell[229582, 4976, 2897, 61, 50, "Print"],
Cell[232482, 5039, 1249, 22, 26, "Print"],
Cell[233734, 5063, 2121, 34, 50, "Print"],
Cell[235858, 5099, 1251, 22, 26, "Print"],
Cell[237112, 5123, 2850, 59, 50, "Print"],
Cell[239965, 5184, 1249, 22, 26, "Print"],
Cell[241217, 5208, 2905, 61, 50, "Print"],
Cell[244125, 5271, 1251, 22, 26, "Print"],
Cell[245379, 5295, 2125, 34, 50, "Print"],
Cell[247507, 5331, 1251, 22, 26, "Print"],
Cell[248761, 5355, 2869, 58, 50, "Print"],
Cell[251633, 5415, 1251, 22, 26, "Print"],
Cell[252887, 5439, 2363, 40, 50, "Print"],
Cell[255253, 5481, 1249, 22, 26, "Print"],
Cell[256505, 5505, 2901, 61, 50, "Print"],
Cell[259409, 5568, 1251, 22, 26, "Print"],
Cell[260663, 5592, 2811, 57, 50, "Print"],
Cell[263477, 5651, 1251, 22, 26, "Print"],
Cell[264731, 5675, 2119, 34, 50, "Print"],
Cell[266853, 5711, 1249, 22, 26, "Print"],
Cell[268105, 5735, 2901, 61, 50, "Print"],
Cell[271009, 5798, 1251, 22, 26, "Print"],
Cell[272263, 5822, 2990, 61, 50, "Print"],
Cell[275256, 5885, 1248, 22, 26, "Print"],
Cell[276507, 5909, 2119, 34, 50, "Print"],
Cell[278629, 5945, 1249, 22, 26, "Print"],
Cell[279881, 5969, 2895, 61, 50, "Print"],
Cell[282779, 6032, 1249, 22, 26, "Print"],
Cell[284031, 6056, 2871, 58, 50, "Print"],
Cell[286905, 6116, 1251, 22, 26, "Print"],
Cell[288159, 6140, 2125, 34, 50, "Print"],
Cell[290287, 6176, 1251, 22, 26, "Print"],
Cell[291541, 6200, 2921, 60, 50, "Print"],
Cell[294465, 6262, 1251, 22, 26, "Print"],
Cell[295719, 6286, 3187, 70, 50, "Print"],
Cell[298909, 6358, 1249, 22, 26, "Print"],
Cell[300161, 6382, 2843, 58, 50, "Print"],
Cell[303007, 6442, 1249, 22, 26, "Print"],
Cell[304259, 6466, 2813, 57, 50, "Print"],
Cell[307075, 6525, 1251, 22, 26, "Print"],
Cell[308329, 6549, 3189, 69, 50, "Print"],
Cell[311521, 6620, 1251, 22, 26, "Print"],
Cell[312775, 6644, 2839, 57, 50, "Print"],
Cell[315617, 6703, 1251, 22, 26, "Print"],
Cell[316871, 6727, 2823, 57, 50, "Print"],
Cell[319697, 6786, 1251, 22, 26, "Print"],
Cell[320951, 6810, 3228, 70, 50, "Print"],
Cell[324182, 6882, 1248, 22, 26, "Print"],
Cell[325433, 6906, 2803, 57, 50, "Print"],
Cell[328239, 6965, 1251, 22, 26, "Print"],
Cell[329493, 6989, 2823, 57, 50, "Print"],
Cell[332319, 7048, 1249, 22, 26, "Print"],
Cell[333571, 7072, 3193, 68, 50, "Print"],
Cell[336767, 7142, 1249, 22, 26, "Print"],
Cell[338019, 7166, 2997, 61, 50, "Print"],
Cell[341019, 7229, 1251, 22, 26, "Print"],
Cell[342273, 7253, 2997, 61, 50, "Print"],
Cell[345273, 7316, 1251, 22, 26, "Print"],
Cell[346527, 7340, 2843, 58, 50, "Print"],
Cell[349373, 7400, 1249, 22, 26, "Print"],
Cell[350625, 7424, 2917, 60, 50, "Print"],
Cell[353545, 7486, 1251, 22, 26, "Print"],
Cell[354799, 7510, 2121, 34, 50, "Print"],
Cell[356923, 7546, 1251, 22, 26, "Print"],
Cell[358177, 7570, 2837, 57, 50, "Print"],
Cell[361017, 7629, 1249, 22, 26, "Print"],
Cell[362269, 7653, 2901, 61, 50, "Print"],
Cell[365173, 7716, 1251, 22, 26, "Print"],
Cell[366427, 7740, 2327, 39, 50, "Print"],
Cell[368757, 7781, 1251, 22, 26, "Print"],
Cell[370011, 7805, 2849, 59, 50, "Print"],
Cell[372863, 7866, 1251, 22, 26, "Print"],
Cell[374117, 7890, 2901, 61, 50, "Print"],
Cell[377021, 7953, 1248, 22, 26, "Print"],
Cell[378272, 7977, 2121, 34, 50, "Print"],
Cell[380396, 8013, 1251, 22, 26, "Print"],
Cell[381650, 8037, 3065, 64, 50, "Print"],
Cell[384718, 8103, 1251, 22, 26, "Print"],
Cell[385972, 8127, 2899, 61, 50, "Print"],
Cell[388874, 8190, 1251, 22, 26, "Print"],
Cell[390128, 8214, 2123, 34, 50, "Print"],
Cell[392254, 8250, 1249, 22, 26, "Print"],
Cell[393506, 8274, 2855, 58, 50, "Print"],
Cell[396364, 8334, 1251, 22, 26, "Print"],
Cell[397618, 8358, 2121, 34, 50, "Print"],
Cell[399742, 8394, 1251, 22, 26, "Print"],
Cell[400996, 8418, 2901, 61, 50, "Print"],
Cell[403900, 8481, 1251, 22, 26, "Print"],
Cell[405154, 8505, 2821, 57, 50, "Print"],
Cell[407978, 8564, 1251, 22, 26, "Print"],
Cell[409232, 8588, 2325, 39, 50, "Print"],
Cell[411560, 8629, 1249, 22, 26, "Print"],
Cell[412812, 8653, 2901, 61, 50, "Print"],
Cell[415716, 8716, 1251, 22, 26, "Print"],
Cell[416970, 8740, 2825, 57, 50, "Print"],
Cell[419798, 8799, 1251, 22, 26, "Print"],
Cell[421052, 8823, 2121, 34, 50, "Print"],
Cell[423176, 8859, 1251, 22, 26, "Print"],
Cell[424430, 8883, 2917, 60, 50, "Print"],
Cell[427350, 8945, 1251, 22, 26, "Print"],
Cell[428604, 8969, 3063, 64, 50, "Print"],
Cell[431670, 9035, 1249, 22, 26, "Print"],
Cell[432922, 9059, 2125, 34, 50, "Print"],
Cell[435050, 9095, 1251, 22, 26, "Print"],
Cell[436304, 9119, 2901, 61, 50, "Print"],
Cell[439208, 9182, 1251, 22, 26, "Print"],
Cell[440462, 9206, 3191, 68, 50, "Print"],
Cell[443656, 9276, 1249, 22, 26, "Print"],
Cell[444908, 9300, 3061, 64, 50, "Print"],
Cell[447972, 9366, 1251, 22, 26, "Print"],
Cell[449226, 9390, 2991, 61, 50, "Print"],
Cell[452220, 9453, 1249, 22, 26, "Print"],
Cell[453472, 9477, 3229, 70, 50, "Print"],
Cell[456704, 9549, 1249, 22, 26, "Print"],
Cell[457956, 9573, 2849, 59, 50, "Print"],
Cell[460808, 9634, 1251, 22, 26, "Print"],
Cell[462062, 9658, 2825, 57, 50, "Print"],
Cell[464890, 9717, 1251, 22, 26, "Print"],
Cell[466144, 9741, 3186, 69, 50, "Print"],
Cell[469333, 9812, 1248, 22, 26, "Print"],
Cell[470584, 9836, 2893, 60, 50, "Print"],
Cell[473480, 9898, 1251, 22, 26, "Print"],
Cell[474734, 9922, 2821, 57, 50, "Print"],
Cell[477558, 9981, 1249, 22, 26, "Print"],
Cell[478810, 10005, 3193, 70, 50, "Print"],
Cell[482006, 10077, 1251, 22, 26, "Print"],
Cell[483260, 10101, 2869, 56, 50, "Print"],
Cell[486132, 10159, 1249, 22, 26, "Print"],
Cell[487384, 10183, 2815, 57, 50, "Print"],
Cell[490202, 10242, 1249, 22, 26, "Print"],
Cell[491454, 10266, 2993, 61, 50, "Print"],
Cell[494450, 10329, 1251, 22, 26, "Print"],
Cell[495704, 10353, 2897, 61, 50, "Print"],
Cell[498604, 10416, 1251, 22, 26, "Print"],
Cell[499858, 10440, 2121, 34, 50, "Print"],
Cell[501982, 10476, 1251, 22, 26, "Print"],
Cell[503236, 10500, 2800, 57, 50, "Print"],
Cell[506039, 10559, 1249, 22, 26, "Print"],
Cell[507291, 10583, 2899, 61, 50, "Print"],
Cell[510193, 10646, 1249, 22, 26, "Print"],
Cell[511445, 10670, 2121, 34, 50, "Print"],
Cell[513569, 10706, 1251, 22, 26, "Print"],
Cell[514823, 10730, 2893, 60, 50, "Print"],
Cell[517719, 10792, 1251, 22, 26, "Print"],
Cell[518973, 10816, 2899, 61, 50, "Print"],
Cell[521875, 10879, 1249, 22, 26, "Print"],
Cell[523127, 10903, 2363, 40, 50, "Print"],
Cell[525493, 10945, 1249, 22, 26, "Print"],
Cell[526745, 10969, 2871, 56, 50, "Print"],
Cell[529619, 11027, 1248, 22, 26, "Print"],
Cell[530870, 11051, 2919, 60, 50, "Print"],
Cell[533792, 11113, 1249, 22, 26, "Print"],
Cell[535044, 11137, 2123, 34, 50, "Print"],
Cell[537170, 11173, 1249, 22, 26, "Print"],
Cell[538422, 11197, 3061, 64, 50, "Print"],
Cell[541486, 11263, 1251, 22, 26, "Print"],
Cell[542740, 11287, 2119, 34, 50, "Print"],
Cell[544862, 11323, 1249, 22, 26, "Print"],
Cell[546114, 11347, 2897, 61, 50, "Print"],
Cell[549014, 11410, 1251, 22, 26, "Print"],
Cell[550268, 11434, 2823, 57, 50, "Print"],
Cell[553094, 11493, 1249, 22, 26, "Print"],
Cell[554346, 11517, 2119, 34, 50, "Print"],
Cell[556468, 11553, 1249, 22, 26, "Print"],
Cell[557720, 11577, 2915, 60, 50, "Print"],
Cell[560638, 11639, 1249, 22, 26, "Print"],
Cell[561890, 11663, 2821, 57, 50, "Print"],
Cell[564714, 11722, 1249, 22, 26, "Print"],
Cell[565966, 11746, 2365, 40, 50, "Print"],
Cell[568334, 11788, 1251, 22, 26, "Print"],
Cell[569588, 11812, 2899, 61, 50, "Print"],
Cell[572490, 11875, 1249, 22, 26, "Print"],
Cell[573742, 11899, 2859, 58, 50, "Print"],
Cell[576604, 11959, 1251, 22, 26, "Print"],
Cell[577858, 11983, 2125, 34, 50, "Print"],
Cell[579986, 12019, 1251, 22, 26, "Print"],
Cell[581240, 12043, 2903, 61, 50, "Print"],
Cell[584146, 12106, 1249, 22, 26, "Print"],
Cell[585398, 12130, 3233, 70, 50, "Print"],
Cell[588634, 12202, 1249, 22, 26, "Print"],
Cell[589886, 12226, 2851, 59, 50, "Print"],
Cell[592740, 12287, 1249, 22, 26, "Print"],
Cell[593992, 12311, 2871, 58, 50, "Print"],
Cell[596866, 12371, 1251, 22, 26, "Print"],
Cell[598120, 12395, 3195, 68, 50, "Print"],
Cell[601318, 12465, 1249, 22, 26, "Print"],
Cell[602570, 12489, 3063, 64, 50, "Print"],
Cell[605636, 12555, 1249, 22, 26, "Print"],
Cell[606888, 12579, 3065, 64, 50, "Print"],
Cell[609956, 12645, 1251, 22, 26, "Print"],
Cell[611210, 12669, 3193, 70, 50, "Print"],
Cell[614406, 12741, 1251, 22, 26, "Print"],
Cell[615660, 12765, 2868, 56, 50, "Print"],
Cell[618531, 12823, 1249, 22, 26, "Print"],
Cell[619783, 12847, 2859, 58, 50, "Print"],
Cell[622645, 12907, 1251, 22, 26, "Print"],
Cell[623899, 12931, 3195, 69, 50, "Print"],
Cell[627097, 13002, 1251, 22, 26, "Print"],
Cell[628351, 13026, 2899, 60, 50, "Print"],
Cell[631253, 13088, 1249, 22, 26, "Print"],
Cell[632505, 13112, 2875, 58, 50, "Print"],
Cell[635383, 13172, 1251, 22, 26, "Print"],
Cell[636637, 13196, 2805, 57, 50, "Print"],
Cell[639445, 13255, 1251, 22, 26, "Print"],
Cell[640699, 13279, 2903, 61, 50, "Print"],
Cell[643605, 13342, 1249, 22, 26, "Print"],
Cell[644857, 13366, 2123, 34, 50, "Print"],
Cell[646983, 13402, 1249, 22, 26, "Print"],
Cell[648235, 13426, 2995, 61, 50, "Print"],
Cell[651233, 13489, 1248, 22, 26, "Print"],
Cell[652484, 13513, 2901, 61, 50, "Print"],
Cell[655388, 13576, 1251, 22, 26, "Print"],
Cell[656642, 13600, 2123, 34, 50, "Print"],
Cell[658768, 13636, 1249, 22, 26, "Print"],
Cell[660020, 13660, 2871, 56, 50, "Print"],
Cell[662894, 13718, 1251, 22, 26, "Print"],
Cell[664148, 13742, 2921, 60, 50, "Print"],
Cell[667072, 13804, 1251, 22, 26, "Print"],
Cell[668326, 13828, 2125, 34, 50, "Print"],
Cell[670454, 13864, 1251, 22, 26, "Print"],
Cell[671708, 13888, 2899, 60, 50, "Print"],
Cell[674610, 13950, 1249, 22, 26, "Print"],
Cell[675862, 13974, 2907, 61, 50, "Print"],
Cell[678772, 14037, 1251, 22, 26, "Print"],
Cell[680026, 14061, 2335, 39, 50, "Print"],
Cell[682364, 14102, 1251, 22, 26, "Print"],
Cell[683618, 14126, 2871, 58, 50, "Print"],
Cell[686492, 14186, 1251, 22, 26, "Print"],
Cell[687746, 14210, 2123, 34, 50, "Print"],
Cell[689872, 14246, 1249, 22, 26, "Print"],
Cell[691124, 14270, 2919, 60, 50, "Print"],
Cell[694046, 14332, 1251, 22, 26, "Print"],
Cell[695300, 14356, 2997, 61, 50, "Print"],
Cell[698300, 14419, 1251, 22, 26, "Print"],
Cell[699554, 14443, 2125, 34, 50, "Print"],
Cell[701682, 14479, 1251, 22, 26, "Print"],
Cell[702936, 14503, 2901, 61, 50, "Print"],
Cell[705840, 14566, 1251, 22, 26, "Print"],
Cell[707094, 14590, 2815, 57, 50, "Print"],
Cell[709912, 14649, 1249, 22, 26, "Print"],
Cell[711164, 14673, 2125, 34, 50, "Print"],
Cell[713292, 14709, 1251, 22, 26, "Print"],
Cell[714546, 14733, 2905, 61, 50, "Print"],
Cell[717454, 14796, 1251, 22, 26, "Print"],
Cell[718708, 14820, 2877, 58, 50, "Print"],
Cell[721588, 14880, 1249, 22, 26, "Print"],
Cell[722840, 14904, 2333, 39, 50, "Print"],
Cell[725176, 14945, 1249, 22, 26, "Print"],
Cell[726428, 14969, 2907, 61, 50, "Print"],
Cell[729338, 15032, 1249, 22, 26, "Print"],
Cell[730590, 15056, 56823, 1554, 469, "Print"],
Cell[787416, 16612, 56823, 1554, 469, "Print"],
Cell[844242, 18168, 3027, 52, 221, "Print"],
Cell[847272, 18222, 3394, 89, 349, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
